/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.prompts.chat;

import io.lumine.xikage.mythicmobs.utils.Events;
import io.lumine.xikage.mythicmobs.utils.promise.Promise;
import io.lumine.xikage.mythicmobs.utils.prompts.chat.ChatPrompt;
import io.lumine.xikage.mythicmobs.utils.prompts.chat.ChatResponse;
import io.lumine.xikage.mythicmobs.utils.terminable.Terminable;
import io.lumine.xikage.mythicmobs.utils.terminable.composite.CompositeTerminable;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ChatPromptImpl
implements ChatPrompt,
Terminable {
    private final CompositeTerminable registry = CompositeTerminable.create();
    private final Player player;
    private final Promise<ChatResponse> promise = Promise.empty();

    public ChatPromptImpl(Player player) {
        this.player = player;
        Events.subscribe(AsyncPlayerChatEvent.class).handler(event -> {
            if (event.getPlayer().getUniqueId().equals(this.player.getUniqueId())) {
                this.promise.supply(new ChatResponse(event.getPlayer(), event.getMessage()));
                this.terminate();
            }
        }).bindWith(this.registry);
        Events.subscribe(PlayerQuitEvent.class).handler(event -> {
            if (event.getPlayer().getUniqueId().equals(this.player.getUniqueId())) {
                this.promise.supply(null);
                this.terminate();
            }
        }).bindWith(this.registry);
    }

    @Override
    public void close() throws Exception {
        this.registry.closeAndReportException();
    }

    @Override
    public Promise<ChatResponse> get() {
        return this.promise;
    }
}

