/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.serialize;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.lumine.xikage.mythicmobs.utils.gson.GsonSerializable;
import io.lumine.xikage.mythicmobs.utils.gson.JsonBuilder;
import io.lumine.xikage.mythicmobs.utils.serialize.BlockLocus;
import io.lumine.xikage.mythicmobs.utils.serialize.ChunkLocus;
import io.lumine.xikage.mythicmobs.utils.serialize.Direction;
import io.lumine.xikage.mythicmobs.utils.serialize.Orient;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import io.lumine.xikage.mythicmobs.utils.serialize.Zone;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public final class Locus
implements GsonSerializable {
    private final double x;
    private final double y;
    private final double z;

    public static Locus deserialize(JsonElement element) {
        Preconditions.checkArgument(element.isJsonObject());
        JsonObject object = element.getAsJsonObject();
        Preconditions.checkArgument(object.has("x"));
        Preconditions.checkArgument(object.has("y"));
        Preconditions.checkArgument(object.has("z"));
        double x = object.get("x").getAsDouble();
        double y = object.get("y").getAsDouble();
        double z = object.get("z").getAsDouble();
        return Locus.of(x, y, z);
    }

    public static Locus of(double x, double y, double z) {
        return new Locus(x, y, z);
    }

    public static Locus of(Location location) {
        Objects.requireNonNull(location, "location");
        return Locus.of(location.getX(), location.getY(), location.getZ());
    }

    public static Locus of(Block block) {
        Objects.requireNonNull(block, "block");
        return Locus.of(block.getLocation());
    }

    private Locus(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public synchronized Location toLocation(String world) {
        return this.toLocation(Bukkit.getWorld((String)world));
    }

    public synchronized Location toLocation(World world) {
        return new Location(world, this.x, this.y, this.z);
    }

    public synchronized Position toPosition(String world) {
        return this.toPosition(Bukkit.getWorld((String)world));
    }

    public synchronized Position toPosition(World world) {
        return Position.of(this.x, this.y, this.z, world);
    }

    public ChunkLocus toChunk() {
        return ChunkLocus.of((int)this.x >> 4, (int)this.z >> 4);
    }

    public BlockLocus floor() {
        return BlockLocus.of(Locus.bukkitFloor(this.x), Locus.bukkitFloor(this.y), Locus.bukkitFloor(this.z));
    }

    public Locus getRelative(BlockFace face) {
        Objects.requireNonNull(face, "face");
        return Locus.of(this.x + (double)face.getModX(), this.y + (double)face.getModY(), this.z + (double)face.getModZ());
    }

    public Locus getRelative(BlockFace face, double distance) {
        Objects.requireNonNull(face, "face");
        return Locus.of(this.x + (double)face.getModX() * distance, this.y + (double)face.getModY() * distance, this.z + (double)face.getModZ() * distance);
    }

    public Locus add(Vector vector3i) {
        return this.add(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Locus add(double x, double y, double z) {
        return Locus.of(this.x + x, this.y + y, this.z + z);
    }

    public Locus subtract(Vector vector3i) {
        return this.subtract(vector3i.getX(), vector3i.getY(), vector3i.getZ());
    }

    public Locus subtract(double x, double y, double z) {
        return this.add(-x, -y, -z);
    }

    public Zone zoneWith(Locus other) {
        Objects.requireNonNull(other, "other");
        return Zone.of(this, other);
    }

    public Orient withDirection(Direction direction) {
        return Orient.of(this, direction);
    }

    public Locus transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.x - aboutX;
        double z = this.z - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return Locus.of(x2 + aboutX + translateX, this.y, z2 + aboutZ + translateZ);
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        return JsonBuilder.object().add("x", this.x).add("y", this.y).add("z", this.z).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Locus)) {
            return false;
        }
        Locus other = (Locus)o;
        return Double.compare(this.getX(), other.getX()) == 0 && Double.compare(this.getY(), other.getY()) == 0 && Double.compare(this.getZ(), other.getZ()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long x = Double.doubleToLongBits(this.getX());
        long y = Double.doubleToLongBits(this.getY());
        long z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)(x >>> 32 ^ x);
        result = result * 59 + (int)(y >>> 32 ^ y);
        result = result * 59 + (int)(z >>> 32 ^ z);
        return result;
    }

    public String toString() {
        return "Locus(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    private static int bukkitFloor(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }
}

