/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.utils.worldedit;

import com.boydti.fawe.FaweAPI;
import com.google.common.collect.Lists;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.logging.Log;
import io.lumine.xikage.mythicmobs.utils.serialize.Locus;
import io.lumine.xikage.mythicmobs.utils.serialize.Position;
import io.lumine.xikage.mythicmobs.utils.serialize.Region;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;

public final class Regions {
    public static WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    public static BlockVector3 toWEVector(Position from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static BlockVector3 toWEVector(Locus from) {
        return BlockVector3.at((double)from.getX(), (double)from.getY(), (double)from.getZ());
    }

    public static Locus fromWEVector(BlockVector3 from) {
        return Locus.of(from.getX(), from.getY(), from.getZ());
    }

    public static Position fromWEVector(BlockVector3 from, World fromWorld) {
        org.bukkit.World world = BukkitAdapter.adapt((World)fromWorld);
        return Position.of((double)from.getX(), (double)from.getY(), (double)from.getZ(), world);
    }

    public static com.sk89q.worldedit.regions.Region toWERegion(Region from) {
        World world = BukkitAdapter.adapt((org.bukkit.World)from.getMin().toLocation().getWorld());
        BlockVector3 min2 = Regions.toWEVector(from.getMin());
        BlockVector3 max = Regions.toWEVector(from.getMax());
        return new CuboidRegion(world, min2, max);
    }

    public static Region fromWERegion(com.sk89q.worldedit.regions.Region from) {
        Position min2 = Regions.fromWEVector(from.getMinimumPoint(), from.getWorld());
        Position max = Regions.fromWEVector(from.getMaximumPoint(), from.getWorld());
        return Region.of(min2, max);
    }

    public static World toWEWorld(Position from) {
        return BukkitAdapter.adapt((org.bukkit.World)from.toLocation().getWorld());
    }

    public static Optional<Region> getPlayerSelection(Player player) {
        BukkitPlayer absPlayer = BukkitAdapter.adapt((Player)player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().getIfPresent((SessionOwner)absPlayer);
        World absWorld = session.getSelectionWorld();
        try {
            if (absWorld == null) {
                return Optional.empty();
            }
            com.sk89q.worldedit.regions.Region region = session.getSelection(absWorld);
            if (region != null) {
                org.bukkit.World world = BukkitAdapter.adapt((World)region.getWorld());
                BlockVector3 min2 = region.getMinimumPoint();
                BlockVector3 max = region.getMaximumPoint();
                return Optional.of(Region.of(Position.of((double)min2.getX(), (double)min2.getY(), (double)min2.getZ(), world), Position.of((double)max.getX(), (double)max.getY(), (double)max.getZ(), world)));
            }
            return Optional.empty();
        }
        catch (Error | Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public static void setRegion(Region region, Material material) {
        com.sk89q.worldedit.regions.Region weRegion = Regions.toWERegion(region);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(weRegion.getWorld(), -1);
        BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
        Schedulers.async().run(() -> editSession.setBlocks(weRegion, (BlockStateHolder)to));
        Schedulers.sync().runLater(() -> {
            editSession.flushQueue();
            editSession.close();
        }, 1L);
    }

    public static void replaceRegion(Region region, Collection<Material> replace, Material material) {
        com.sk89q.worldedit.regions.Region weRegion = Regions.toWERegion(region);
        EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(weRegion.getWorld(), -1);
        HashSet<BaseBlock> baseBlocks = new HashSet<BaseBlock>();
        for (Material m3 : replace) {
            baseBlocks.add(BukkitAdapter.adapt((BlockData)m3.createBlockData()).toBaseBlock());
        }
        BaseBlock to = BukkitAdapter.adapt((BlockData)material.createBlockData()).toBaseBlock();
        Schedulers.async().run(() -> {
            editSession.replaceBlocks(weRegion, baseBlocks, (BlockStateHolder)to);
            editSession.flushQueue();
            editSession.close();
        });
    }

    public static Optional<Clipboard> loadSchematic(File schematicFile) {
        if (!schematicFile.exists()) {
            Log.error("Schematic file " + schematicFile.getAbsolutePath() + " doesnt exist");
            return Optional.empty();
        }
        ClipboardFormat schematicFormat = ClipboardFormats.findByFile((File)schematicFile);
        if (schematicFormat == null) {
            Log.error("Schematic file " + schematicFile.getAbsolutePath() + " is corrupt");
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(schematicFormat.load(schematicFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, boolean ignoreAir) {
        Regions.pasteSchematic(schematic, pasteLocation, 0, false);
    }

    public static void pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir) {
        BlockVector3 pastePosition = Regions.toWEVector(pasteLocation);
        World faweWorld = Regions.toWEWorld(pasteLocation);
        schematic.setOrigin(schematic.getMinimumPoint());
        try (EditSession editSession = FaweAPI.getEditSessionBuilder((World)faweWorld).fastmode(Boolean.valueOf(true)).build();){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY(180.0);
                holder.setTransform((Transform)tr);
            }
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
        }
    }

    public static Collection<Position> pasteSchematic(Clipboard schematic, Position pasteLocation, int rotation, boolean ignoreAir, Collection<Material> blockPositions) {
        BlockVector3 pastePosition = Regions.toWEVector(pasteLocation);
        World faweWorld = Regions.toWEWorld(pasteLocation);
        schematic.setOrigin(schematic.getMinimumPoint());
        try (EditSession editSession = FaweAPI.getEditSessionBuilder((World)faweWorld).fastmode(Boolean.valueOf(true)).build();){
            ClipboardHolder holder = new ClipboardHolder(schematic);
            if (rotation != 0) {
                AffineTransform tr = new AffineTransform();
                tr = tr.rotateY(180.0);
                holder.setTransform((Transform)tr);
            }
            ArrayList<Position> ret = Lists.newArrayList();
            holder.getClipboards().forEach(clipboard -> clipboard.forEach(vector -> {
                BlockState state = clipboard.getBlock(vector);
                if (state.getBlockType() == BlockTypes.CHEST) {
                    double x = pasteLocation.getX() + (double)vector.getBlockX();
                    double y = pasteLocation.getY() + (double)vector.getBlockY();
                    double z = pasteLocation.getZ() + (double)vector.getBlockZ();
                    ret.add(Position.of(x, y, z, pasteLocation.getWorld()));
                    Log.info("Found chest at {0} == {1},{2},{3}", vector.toString(), x, y, z);
                }
            }));
            Operation operation = holder.createPaste((Extent)editSession).to(pastePosition).ignoreAirBlocks(ignoreAir).build();
            try {
                Operations.complete((Operation)operation);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            editSession.flushSession();
            ArrayList<Position> arrayList = ret;
            return arrayList;
        }
    }
}

