/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.xikage.mythicmobs.volatilecode.v1_16_R2;

import io.lumine.xikage.mythicmobs.adapters.AbstractEntity;
import io.lumine.xikage.mythicmobs.adapters.AbstractLocation;
import io.lumine.xikage.mythicmobs.adapters.AbstractVector;
import io.lumine.xikage.mythicmobs.adapters.AbstractWorld;
import io.lumine.xikage.mythicmobs.adapters.bukkit.BukkitAdapter;
import io.lumine.xikage.mythicmobs.utils.Schedulers;
import io.lumine.xikage.mythicmobs.utils.reflection.Reflector;
import io.lumine.xikage.mythicmobs.volatilecode.VolatileCodeHandler;
import io.lumine.xikage.mythicmobs.volatilecode.handlers.VolatileWorldHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Chunk;
import net.minecraft.server.v1_16_R2.ChunkProviderServer;
import net.minecraft.server.v1_16_R2.DifficultyDamageScaler;
import net.minecraft.server.v1_16_R2.EntityFallingBlock;
import net.minecraft.server.v1_16_R2.IBlockData;
import net.minecraft.server.v1_16_R2.MathHelper;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R2.Vec3D;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class VolatileWorldHandler_v1_16_R2
implements VolatileWorldHandler {
    private static final Reflector<ChunkProviderServer> refChunkProviderServer = new Reflector<ChunkProviderServer>(ChunkProviderServer.class, "serverThread");
    private static final Reflector<net.minecraft.server.v1_16_R2.World> refWorldThread = new Reflector<net.minecraft.server.v1_16_R2.World>(net.minecraft.server.v1_16_R2.World.class, "serverThread");
    public Thread resetServerThread;

    public VolatileWorldHandler_v1_16_R2(VolatileCodeHandler handler) {
    }

    @Override
    public void registerWorldAccess(World world) {
    }

    @Override
    public void unregisterWorldAccess(World world) {
    }

    @Override
    public void playSoundAtLocation(AbstractLocation location, String sound, float volume, float pitch, double radius) {
        Location l = BukkitAdapter.adapt(location);
        l.getWorld().playSound(l, sound, volume, pitch);
    }

    @Override
    public boolean isChunkLoaded(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        return null != nmsWorld.getChunkAt(x, z);
    }

    @Override
    public int getEntitiesInChunk(AbstractWorld world, int x, int z) {
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(world);
        WorldServer nmsWorld = bukkitWorld.getHandle();
        Chunk chunk = nmsWorld.getChunkAt(x, z);
        if (chunk == null) {
            return 0;
        }
        int amount = 0;
        for (List slice : chunk.getEntitySlices()) {
            amount += slice.size();
        }
        return amount;
    }

    @Override
    public void doBlockTossEffect(AbstractLocation target, Material material, AbstractVector velocity, int duration, boolean hideSourceBlock) {
        Location location = BukkitAdapter.adapt(target);
        BlockPosition blockPosition = new BlockPosition(target.getBlockX(), target.getBlockY(), target.getBlockZ());
        CraftWorld bukkitWorld = (CraftWorld)location.getWorld();
        WorldServer nmsWorld = bukkitWorld.getHandle();
        IBlockData blockState = material == null ? nmsWorld.getType(blockPosition) : ((CraftBlockData)Bukkit.createBlockData((Material)material)).getState();
        EntityFallingBlock block = new EntityFallingBlock((net.minecraft.server.v1_16_R2.World)nmsWorld, (double)target.getBlockX() + 0.5, (double)(target.getBlockY() + 1), (double)target.getBlockZ() + 0.5, blockState);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity((net.minecraft.server.v1_16_R2.Entity)block, block.getEntityType(), net.minecraft.server.v1_16_R2.Block.getCombinedId((IBlockData)blockState), blockPosition);
        PacketPlayOutEntityVelocity packetV = new PacketPlayOutEntityVelocity(block.getId(), new Vec3D(velocity.getX(), velocity.getY(), velocity.getZ()));
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (hideSourceBlock) {
                p.sendBlockChange(location, Material.AIR, (byte)0);
            }
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet);
            ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packetV);
            Schedulers.async().runLater(() -> {
                PacketPlayOutEntityDestroy packet2 = new PacketPlayOutEntityDestroy(new int[]{block.getId()});
                ((CraftPlayer)p).getHandle().playerConnection.sendPacket((Packet)packet2);
                if (hideSourceBlock) {
                    p.sendBlockChange(location, location.getBlock().getType(), (byte)0);
                }
            }, duration);
        }
    }

    @Override
    public float getDifficultyScale(AbstractLocation location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        DifficultyDamageScaler scaler = ((CraftWorld)location.getWorld()).getHandle().getDamageScaler(pos);
        return scaler.b();
    }

    @Override
    public Collection<AbstractEntity> getEntitiesNearLocation(AbstractLocation location, double radius, Predicate<AbstractEntity> predicate) {
        ArrayList<AbstractEntity> entities = new ArrayList<AbstractEntity>();
        CraftWorld bukkitWorld = (CraftWorld)BukkitAdapter.adapt(location.getWorld());
        WorldServer nmsWorld = bukkitWorld.getHandle();
        int smallX = MathHelper.floor((double)((location.getX() - radius) / 16.0));
        int bigX = MathHelper.floor((double)((location.getX() + radius) / 16.0));
        int smallZ = MathHelper.floor((double)((location.getZ() - radius) / 16.0));
        int bigZ = MathHelper.floor((double)((location.getZ() + radius) / 16.0));
        for (int x = smallX; x <= bigX; ++x) {
            for (int z = smallZ; z <= bigZ; ++z) {
                Chunk chunk = nmsWorld.getChunkAt(x, z);
                if (null == chunk) continue;
                for (List slice : chunk.getEntitySlices()) {
                    for (net.minecraft.server.v1_16_R2.Entity e : slice) {
                        AbstractEntity entity = BukkitAdapter.adapt((Entity)e.getBukkitEntity());
                        if (predicate != null && !predicate.test(entity)) continue;
                        entities.add(entity);
                    }
                }
            }
        }
        return entities;
    }

    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Validate.notNull(start, "Start location is null!", new Object[0]);
        start.checkFinite();
        Validate.notNull(direction, "Direction is null!", new Object[0]);
        direction.checkFinite();
        Validate.isTrue(direction.lengthSquared() > 0.0, "Direction's magnitude is 0!", new Object[0]);
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection entities = start.getWorld().getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> entityFilter, Predicate<Material> blockFilter) {
        if (direction.lengthSquared() < 1.0E-5 || maxDistance <= 1.0E-5) {
            return null;
        }
        RayTraceResult blockRayTrace = null;
        RayTraceResult entityRayTrace = start.getWorld().rayTraceEntities(start, direction, maxDistance, raySize, entityFilter);
        double distance = entityRayTrace != null && entityRayTrace.getHitEntity() != null ? start.distance(entityRayTrace.getHitEntity().getLocation()) : maxDistance;
        BlockIterator bIterator = new BlockIterator(start.getWorld(), start.toVector(), direction, 0.0, (int)Math.ceil(distance));
        Block block = null;
        while (bIterator.hasNext()) {
            RayTraceResult res;
            block = bIterator.next();
            if (block.isEmpty() || blockFilter.test(block.getType()) || (res = block.rayTrace(start, direction, distance, FluidCollisionMode.ALWAYS)) == null) continue;
            blockRayTrace = res;
            break;
        }
        if (entityRayTrace != null && entityRayTrace.getHitEntity() != null) {
            if (blockRayTrace != null) {
                return blockRayTrace;
            }
            return entityRayTrace;
        }
        if (blockRayTrace != null) {
            return blockRayTrace;
        }
        return new RayTraceResult(block.getLocation().toVector());
    }

    @Override
    public void changeWorldServerThread(World world) {
        if (this.resetServerThread != null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.getChunkProvider();
        try {
            this.resetServerThread = (Thread)refChunkProviderServer.get(provider, "serverThread");
            refChunkProviderServer.set(provider, "serverThread", Thread.currentThread());
            refWorldThread.set((net.minecraft.server.v1_16_R2.World)nmsWorld, "serverThread", Thread.currentThread());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void restoreWorldServerThread(World world) {
        if (this.resetServerThread == null) {
            return;
        }
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        ChunkProviderServer provider = nmsWorld.getChunkProvider();
        try {
            refChunkProviderServer.set(provider, "serverThread", this.resetServerThread);
            refWorldThread.set((net.minecraft.server.v1_16_R2.World)nmsWorld, "serverThread", this.resetServerThread);
            this.resetServerThread = null;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

