/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt;

import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.PapiExpansion;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.potion.BrewingManager;
import com.volmit.adapt.api.protection.ProtectorRegistry;
import com.volmit.adapt.api.tick.Ticker;
import com.volmit.adapt.api.value.MaterialValue;
import com.volmit.adapt.api.world.AdaptServer;
import com.volmit.adapt.command.CommandAdapt;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.content.protector.ChestProtectProtector;
import com.volmit.adapt.content.protector.FactionsClaimProtector;
import com.volmit.adapt.content.protector.ResidenceProtector;
import com.volmit.adapt.content.protector.WorldGuardProtector;
import com.volmit.adapt.nms.GlowingEntities;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.Metrics;
import com.volmit.adapt.util.SQLManager;
import com.volmit.adapt.util.VolmitPlugin;
import com.volmit.adapt.util.Window;
import com.volmit.adapt.util.arcane.amulet.io.FolderWatcher;
import com.volmit.adapt.util.command.AdaptSuggestionProvider;
import com.volmit.adapt.util.command.AdaptSuggestionProviderListing;
import com.volmit.adapt.util.command.ParticleSuggestionProvider;
import com.volmit.adapt.util.command.SoundSuggestionProvider;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import com.volmit.adapt.util.secret.SecretSplash;
import de.slikey.effectlib.EffectManager;
import io.github.mqzn.commands.SpigotCommandManager;
import io.github.mqzn.commands.annotations.AnnotationParser;
import io.github.mqzn.commands.base.SuggestionProvider;
import io.github.mqzn.commands.base.manager.CommandExecutionCoordinator;
import io.github.mqzn.commands.base.manager.CommandManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Adapt
extends VolmitPlugin {
    public static Adapt instance;
    public static HashMap<String, String> wordKey;
    public final EffectManager adaptEffectManager = new EffectManager((Plugin)this);
    public static BukkitAudiences audiences;
    private SpigotCommandManager commandManager;
    private AnnotationParser<CommandSender> parser;
    private GlowingEntities glowingEntities;
    private Ticker ticker;
    private AdaptServer adaptServer;
    private FolderWatcher configWatcher;
    private SQLManager sqlManager;
    private ProtectorRegistry protectorRegistry;
    private Map<String, Window> guiLeftovers = new HashMap<String, Window>();

    public Adapt() {
        instance = this;
    }

    @Override
    public void start() {
        audiences = BukkitAudiences.create((Plugin)this);
        this.commandManager = new SpigotCommandManager((Plugin)this, CommandExecutionCoordinator.Type.SYNC);
        this.parser = new AnnotationParser((CommandManager)this.commandManager);
        this.commandManager.suggestionProviderRegistry().register((SuggestionProvider)new AdaptSuggestionProvider());
        this.commandManager.suggestionProviderRegistry().register((SuggestionProvider)new AdaptSuggestionProviderListing());
        this.commandManager.suggestionProviderRegistry().register((SuggestionProvider)new SoundSuggestionProvider());
        this.commandManager.suggestionProviderRegistry().register((SuggestionProvider)new ParticleSuggestionProvider());
        NMS.init();
        Localizer.updateLanguageFile();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PapiExpansion().register();
        }
        Adapt.printInformation();
        this.sqlManager = new SQLManager();
        if (AdaptConfig.get().isUseSql()) {
            this.sqlManager.establishConnection();
        }
        this.startSim();
        this.registerListener(new BrewingManager());
        this.setupMetrics();
        this.startupPrint();
        if (AdaptConfig.get().isAutoUpdateCheck()) {
            Adapt.autoUpdateCheck();
        }
        this.protectorRegistry = new ProtectorRegistry();
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.protectorRegistry.registerProtector(new WorldGuardProtector());
        }
        if (this.getServer().getPluginManager().getPlugin("Factions") != null) {
            this.protectorRegistry.registerProtector(new FactionsClaimProtector());
        }
        if (this.getServer().getPluginManager().getPlugin("ChestProtect") != null) {
            this.protectorRegistry.registerProtector(new ChestProtectProtector());
        }
        if (this.getServer().getPluginManager().getPlugin("Residence") != null) {
            this.protectorRegistry.registerProtector(new ResidenceProtector());
        }
        this.glowingEntities = new GlowingEntities((Plugin)this);
        this.parser.parse((Object)new CommandAdapt());
    }

    public void startSim() {
        this.ticker = new Ticker();
        this.adaptServer = new AdaptServer();
    }

    public void stopSim() {
        this.ticker.clear();
        this.adaptServer.unregister();
        MaterialValue.save();
        WorldData.stop();
    }

    @Override
    public void stop() {
        this.sqlManager.closeConnection();
        this.stopSim();
        this.protectorRegistry.unregisterAll();
    }

    private void startupPrint() {
        if (!AdaptConfig.get().isSplashScreen()) {
            return;
        }
        Random r = new Random();
        int game = r.nextInt(100);
        if (game < 90) {
            Adapt.info("\n" + C.GRAY + " \u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2557 " + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2557  " + C.GRAY + "\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2557 " + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2557 " + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2557\n" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2557" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2557" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2557" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2557\u255a\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550\u255d" + C.WHITE + "         Version: " + C.DARK_RED + instance.getDescription().getVersion() + "     \n" + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551  " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2554\u255d   " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.WHITE + "            By: " + C.RED + "A" + C.GOLD + "r" + C.YELLOW + "c" + C.GREEN + "a" + C.DARK_GRAY + "n" + C.AQUA + "e " + C.AQUA + "A" + C.BLUE + "r" + C.DARK_BLUE + "t" + C.DARK_PURPLE + "s" + C.WHITE + " (Volmit Software)\n" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551  " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2554\u2550\u2550\u2550\u255d    " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.WHITE + "            Java Version: " + C.DARK_RED + Adapt.getJavaVersion() + "     \n" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551  " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588\u2588\u2588\u2588\u2588" + C.DARK_RED + "\u2554\u255d" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551  " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551" + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551        " + C.GRAY + "\u2588\u2588" + C.DARK_RED + "\u2551   \n" + C.DARK_RED + "\u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u2550\u2550\u2550\u2550\u255d \u255a\u2550\u255d  \u255a\u2550\u255d\u255a\u2550\u255d        \u255a\u2550\u255d   \n");
        } else {
            Adapt.info(XList.getRandom(SecretSplash.getSecretSplash()));
        }
    }

    public File getJarFile() {
        return this.getFile();
    }

    @Override
    public String getTag(String subTag) {
        return C.BOLD + C.DARK_GRAY + "[" + C.BOLD + C.DARK_RED + "Adapt" + C.BOLD + C.DARK_GRAY + "]" + C.RESET + C.GRAY + ": ";
    }

    private void setupMetrics() {
        if (AdaptConfig.get().isMetrics()) {
            new Metrics(this, 13412);
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static void printInformation() {
        Adapt.debug("XP Curve: " + AdaptConfig.get().getXpCurve());
        Adapt.debug("XP/Level base: " + AdaptConfig.get().getPlayerXpPerSkillLevelUpBase());
        Adapt.debug("XP/Level multiplier: " + AdaptConfig.get().getPlayerXpPerSkillLevelUpLevelMultiplier());
        Adapt.info("Language: " + AdaptConfig.get().getLanguage() + " - Language Fallback: " + AdaptConfig.get().getFallbackLanguageDontChangeUnlessYouKnowWhatYouAreDoing());
    }

    public static void autoUpdateCheck() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/VolmitSoftware/Adapt/main/build.gradle").openStream()));){
            String inputLine;
            Adapt.info("Checking for updates...");
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.contains("version '")) continue;
                String version = inputLine.replace("version '", "").replace("'", "").replace("// Needs to be version specific", "").replace(" ", "");
                if (instance.getDescription().getVersion().contains("development")) {
                    Adapt.info("Development build detected. Skipping update check.");
                    return;
                }
                if (!version.equals(instance.getDescription().getVersion())) {
                    Adapt.info(MessageFormat.format("Please update your Adapt plugin to the latest version! (Current: {0} Latest: {1})", instance.getDescription().getVersion(), version));
                } else {
                    Adapt.info("You are running the latest version of Adapt!");
                }
                break;
            }
        }
        catch (Throwable e) {
            Adapt.error("Failed to check for updates.");
        }
    }

    public static void actionbar(Player p, String msg) {
        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)msg));
    }

    public static void debug(String string) {
        if (AdaptConfig.get().isDebug()) {
            Adapt.msg(C.DARK_PURPLE + string);
        }
    }

    public static void warn(String string) {
        Adapt.msg(C.YELLOW + string);
    }

    public static void error(String string) {
        Adapt.msg(C.RED + string);
    }

    public static void verbose(String string) {
        if (AdaptConfig.get().isVerbose()) {
            Adapt.msg(C.LIGHT_PURPLE + string);
        }
    }

    public static void success(String string) {
        Adapt.msg(C.GREEN + string);
    }

    public static void info(String string) {
        Adapt.msg(C.WHITE + string);
    }

    public static void messagePlayer(Player p, String string) {
        String msg = C.GRAY + "[" + C.DARK_RED + "Adapt" + C.GRAY + "]: " + string;
        p.sendMessage(msg);
    }

    public static void msg(String string) {
        try {
            if (instance == null) {
                System.out.println("[Adapt]: " + string);
                return;
            }
            String msg = C.GRAY + "[" + C.DARK_RED + "Adapt" + C.GRAY + "]: " + string;
            Bukkit.getConsoleSender().sendMessage(msg);
        }
        catch (Throwable e) {
            System.out.println("[Adapt]: " + string);
        }
    }

    public static void hotloaded() {
        J.s(() -> {
            Adapt.instance.guiLeftovers.values().forEach(window -> {
                HandlerList.unregisterAll((Listener)((Listener)window));
                window.close();
            });
            instance.stop();
            instance.start();
            instance.getGuiLeftovers().forEach((s, window) -> {
                if (window.getTag() != null) {
                    if (window.getTag().equals("/")) {
                        SkillsGui.open(Bukkit.getPlayer((UUID)UUID.fromString(s)));
                    } else {
                        String[] split = window.getTag().split("\\Q/\\E");
                        if (split.length == 2) {
                            if (split[0].equals("skill")) {
                                instance.getAdaptServer().getSkillRegistry().getSkill(split[1]).openGui(Bukkit.getPlayer((UUID)UUID.fromString(s)));
                            }
                        } else if (split.length == 3 && split[0].equals("skill")) {
                            try {
                                XList.where(instance.getAdaptServer().getSkillRegistry().getSkill(split[1]).getAdaptations(), a -> a.getId().equals(split[2])).get(0).openGui(Bukkit.getPlayer((UUID)UUID.fromString(s)));
                            }
                            catch (Throwable e) {
                                instance.getAdaptServer().getSkillRegistry().getSkill(split[1]).openGui(Bukkit.getPlayer((UUID)UUID.fromString(s)));
                            }
                        }
                    }
                }
            });
        }, 20);
    }

    public GlowingEntities getGlowingEntities() {
        return this.glowingEntities;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public AdaptServer getAdaptServer() {
        return this.adaptServer;
    }

    public SQLManager getSqlManager() {
        return this.sqlManager;
    }

    public ProtectorRegistry getProtectorRegistry() {
        return this.protectorRegistry;
    }

    public Map<String, Window> getGuiLeftovers() {
        return this.guiLeftovers;
    }

    static {
        IBootstrap.dasBoot();
        wordKey = new HashMap();
    }
}

