/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt;

import com.google.common.collect.Maps;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansion
extends PlaceholderExpansion {
    private final Map<String, Function<PlayerSkillLine, String>> skillMap = Maps.newHashMap();
    private final Map<String, Function<PlayerData, String>> playerMap = Maps.newHashMap();
    private final Map<String, BiFunction<PlayerSkillLine, PlayerAdaptation, String>> adaptationMap = Maps.newHashMap();

    public PapiExpansion() {
        this.skillMap.put("level", skill -> String.valueOf(skill.getLevel()).equals("-5000") ? "0" : String.valueOf(skill.getLevel()));
        this.skillMap.put("knowledge", skill -> String.valueOf(skill.getKnowledge()).equals("-5000") ? "0" : String.valueOf(skill.getKnowledge()));
        this.skillMap.put("xp", skill -> String.format("%.2f", skill.getXp()).equals("-5000.00") ? "0" : String.format("%.2f", skill.getXp()));
        this.skillMap.put("freshness", skill -> String.valueOf(skill.getFreshness()).equals("-5000") ? "0" : String.valueOf(skill.getFreshness()));
        this.skillMap.put("multiplier", skill -> String.valueOf(skill.getMultiplier()).equals("-5000") ? "0" : String.valueOf(skill.getMultiplier()));
        this.skillMap.put("name", skill -> Localizer.dLocalize("skill", skill.getLine(), "name"));
        this.playerMap.put("level", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getLevel()));
        this.playerMap.put("multiplier", playerData -> String.valueOf(playerData.getMultiplier()).equals("-5000") ? "0" : String.valueOf(playerData.getMultiplier()));
        this.playerMap.put("availablepower", playerData -> String.valueOf(playerData.getAvailablePower()).equals("-5000") ? "0" : String.valueOf(playerData.getAvailablePower()));
        this.playerMap.put("maxpower", playerData -> String.valueOf(playerData.getMaxPower()).equals("-5000") ? "0" : String.valueOf(playerData.getMaxPower()));
        this.playerMap.put("usedpower", playerData -> String.valueOf(playerData.getUsedPower()).equals("-5000") ? "0" : String.valueOf(playerData.getUsedPower()));
        this.playerMap.put("wisdom", playerData -> String.valueOf(playerData.getWisdom()).equals("-5000") ? "0" : String.valueOf(playerData.getWisdom()));
        this.playerMap.put("masterxp", playerData -> String.valueOf(playerData.getMasterXp()).equals("-5000") ? "0" : String.valueOf(playerData.getMasterXp()));
        this.playerMap.put("seenthings", playerData -> String.valueOf(playerData.getSeenBlocks().getSeen().size() + playerData.getSeenBiomes().getSeen().size() + playerData.getSeenEnchants().getSeen().size() + playerData.getSeenEnvironments().getSeen().size() + playerData.getSeenFoods().getSeen().size() + playerData.getSeenItems().getSeen().size() + playerData.getSeenMobs().getSeen().size() + playerData.getSeenPeople().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenRecipes().getSeen().size() + playerData.getSeenPotionEffects().getSeen().size() + playerData.getSeenWorlds().getSeen().size()));
        this.adaptationMap.put("name", (skillLine, adaptation) -> Localizer.dLocalize(skillLine.getLine(), adaptation.getId(), "name"));
        this.adaptationMap.put("level", (skillLine, adaptation) -> String.valueOf(adaptation.getLevel()).equals("-5000") ? "0" : String.valueOf(adaptation.getLevel()));
    }

    @NotNull
    public String getIdentifier() {
        return Adapt.instance.getDescription().getName().toLowerCase();
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Adapt.instance.getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return Adapt.instance.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        block4: {
            PlayerData p;
            String[] args;
            block3: {
                args = params.split("_");
                p = Adapt.instance.getAdaptServer().peekData(player.getUniqueId());
                if (Adapt.instance.getAdaptServer().getSkillRegistry().getSkill(args[0]) != null) break block3;
                for (String k : this.playerMap.keySet()) {
                    if (!k.equalsIgnoreCase(args[0])) continue;
                    return this.playerMap.get(k).apply(p);
                }
                break block4;
            }
            PlayerSkillLine line = p.getSkillLine(args[0]);
            for (String k : this.skillMap.keySet()) {
                if (!k.equalsIgnoreCase(args[1])) continue;
                return this.skillMap.get(k).apply(line);
            }
            String adaptName = args[0] + "-" + args[1];
            if (!line.getAdaptations().containsKey(adaptName)) break block4;
            PlayerAdaptation adapt = line.getAdaptation(adaptName);
            for (String k : this.adaptationMap.keySet()) {
                if (!k.equalsIgnoreCase(args[2])) continue;
                return this.adaptationMap.get(k).apply(line, adapt);
            }
        }
        return null;
    }

    static {
        IBootstrap.dasBoot();
    }
}

