/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.adaptation;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.potion.BrewingRecipe;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.arcane.amulet.io.FileWatcher;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;

public abstract class SimpleAdaptation<T>
extends TickedObject
implements Adaptation<T> {
    private int maxLevel;
    private int initialCost;
    private int baseCost;
    private double costFactor;
    private String displayName;
    private Skill<?> skill;
    private String description;
    private Material icon;
    private String name;
    private List<AdaptAdvancement> cachedAdvancements = new ArrayList<AdaptAdvancement>();
    private List<AdaptRecipe> recipes = new ArrayList<AdaptRecipe>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private Class<T> configType;
    private T config;

    public SimpleAdaptation(String name) {
        super("adaptations", UUID.randomUUID() + "-" + name, 1000L);
        this.setMaxLevel(5);
        this.setCostFactor(0.35);
        this.setBaseCost(3);
        this.setIcon(Material.PAPER);
        this.setInitialCost(1);
        this.setDescription("No Description Provided");
        this.name = name;
        J.a(() -> {
            if (!this.isEnabled()) {
                this.unregister();
            }
        }, 1);
    }

    @Override
    public Class<T> getConfigurationClass() {
        return this.configType;
    }

    @Override
    public void registerConfiguration(Class<T> type) {
        this.configType = type;
        final File file = Adapt.instance.getDataFile("adapt", "adaptations", this.getName() + ".json");
        final FileWatcher fw = new FileWatcher(file);
        fw.checkModified();
        J.a(() -> {
            fw.checkModified();
            Adapt.instance.getTicker().register(new TickedObject("config", "config-adaptation-" + this.getName(), 1000L){

                @Override
                public void onTick() {
                    try {
                        if (fw.checkModified() && file.exists()) {
                            SimpleAdaptation.this.config = null;
                            SimpleAdaptation.this.getConfig();
                            Adapt.info("Hotloaded " + file.getPath());
                            Adapt.hotloaded();
                            fw.checkModified();
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }, 20);
    }

    @Override
    public T getConfig() {
        block7: {
            try {
                if (this.config != null) break block7;
                T dummy = this.getConfigurationClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                File l = Adapt.instance.getDataFile("adapt", "adaptations", this.getName() + ".json");
                if (!l.exists()) {
                    try {
                        IO.writeAll(l, new JSONObject(new Gson().toJson(dummy)).toString(4));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.config = dummy;
                        return this.config;
                    }
                }
                try {
                    this.config = new Gson().fromJson(IO.readAll(l), this.getConfigurationClass());
                    IO.writeAll(l, new JSONObject(new Gson().toJson(this.config)).toString(4));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.config = dummy;
                    return this.config;
                }
            }
            catch (Throwable e) {
                Adapt.verbose("Failed to load config for " + this.getName());
            }
        }
        return this.config;
    }

    public void registerRecipe(AdaptRecipe r) {
        this.recipes.add(r);
    }

    public void registerBrewingRecipe(BrewingRecipe r) {
        this.brewingRecipes.add(r);
    }

    @Override
    public String getDisplayName() {
        try {
            return this.displayName == null ? Adaptation.super.getDisplayName() : C.RESET + C.BOLD + this.getSkill().getColor().toString() + this.displayName;
        }
        catch (Exception ignored) {
            Adapt.verbose("Failed to get display name for " + this.getName());
            return null;
        }
    }

    public void registerAdvancement(AdaptAdvancement a) {
        this.cachedAdvancements.add(a);
    }

    @Override
    public void onRegisterAdvancements(List<AdaptAdvancement> advancements) {
        advancements.addAll(this.cachedAdvancements);
    }

    @Override
    public AdaptAdvancement buildAdvancements() {
        ArrayList<AdaptAdvancement> a = new ArrayList<AdaptAdvancement>();
        this.onRegisterAdvancements(a);
        return AdaptAdvancement.builder().key("adaptation_" + this.getName()).title(C.WHITE + "[     " + this.getDisplayName() + C.WHITE + "     ]").description(this.getDescription() + ". " + Localizer.dLocalize("snippets", "gui", "unlockthisbyclicking") + " " + AdaptConfig.get().adaptActivatorBlockName).icon(this.getIcon()).children(a).visibility(AdvancementVisibility.PARENT_GRANTED).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleAdaptation)) {
            return false;
        }
        SimpleAdaptation other = (SimpleAdaptation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getInitialCost() != other.getInitialCost()) {
            return false;
        }
        if (this.getBaseCost() != other.getBaseCost()) {
            return false;
        }
        if (Double.compare(this.getCostFactor(), other.getCostFactor()) != 0) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Skill<?> this$skill = this.getSkill();
        Skill<?> other$skill = other.getSkill();
        if (this$skill == null ? other$skill != null : !this$skill.equals(other$skill)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Material this$icon = this.getIcon();
        Material other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<AdaptAdvancement> this$cachedAdvancements = this.getCachedAdvancements();
        List<AdaptAdvancement> other$cachedAdvancements = other.getCachedAdvancements();
        if (this$cachedAdvancements == null ? other$cachedAdvancements != null : !((Object)this$cachedAdvancements).equals(other$cachedAdvancements)) {
            return false;
        }
        List<AdaptRecipe> this$recipes = this.getRecipes();
        List<AdaptRecipe> other$recipes = other.getRecipes();
        if (this$recipes == null ? other$recipes != null : !((Object)this$recipes).equals(other$recipes)) {
            return false;
        }
        List<BrewingRecipe> this$brewingRecipes = this.getBrewingRecipes();
        List<BrewingRecipe> other$brewingRecipes = other.getBrewingRecipes();
        if (this$brewingRecipes == null ? other$brewingRecipes != null : !((Object)this$brewingRecipes).equals(other$brewingRecipes)) {
            return false;
        }
        Class<T> this$configType = this.getConfigType();
        Class<T> other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        T this$config = this.getConfig();
        T other$config = other.getConfig();
        return !(this$config == null ? other$config != null : !this$config.equals(other$config));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleAdaptation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getInitialCost();
        result = result * 59 + this.getBaseCost();
        long $costFactor = Double.doubleToLongBits(this.getCostFactor());
        result = result * 59 + (int)($costFactor >>> 32 ^ $costFactor);
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Skill<?> $skill = this.getSkill();
        result = result * 59 + ($skill == null ? 43 : $skill.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Material $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<AdaptAdvancement> $cachedAdvancements = this.getCachedAdvancements();
        result = result * 59 + ($cachedAdvancements == null ? 43 : ((Object)$cachedAdvancements).hashCode());
        List<AdaptRecipe> $recipes = this.getRecipes();
        result = result * 59 + ($recipes == null ? 43 : ((Object)$recipes).hashCode());
        List<BrewingRecipe> $brewingRecipes = this.getBrewingRecipes();
        result = result * 59 + ($brewingRecipes == null ? 43 : ((Object)$brewingRecipes).hashCode());
        Class<T> $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        T $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        return result;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public int getInitialCost() {
        return this.initialCost;
    }

    @Override
    public int getBaseCost() {
        return this.baseCost;
    }

    @Override
    public double getCostFactor() {
        return this.costFactor;
    }

    @Override
    public Skill<?> getSkill() {
        return this.skill;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Material getIcon() {
        return this.icon;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<AdaptAdvancement> getCachedAdvancements() {
        return this.cachedAdvancements;
    }

    @Override
    public List<AdaptRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public List<BrewingRecipe> getBrewingRecipes() {
        return this.brewingRecipes;
    }

    public Class<T> getConfigType() {
        return this.configType;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setInitialCost(int initialCost) {
        this.initialCost = initialCost;
    }

    public void setBaseCost(int baseCost) {
        this.baseCost = baseCost;
    }

    public void setCostFactor(double costFactor) {
        this.costFactor = costFactor;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void setSkill(Skill<?> skill) {
        this.skill = skill;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCachedAdvancements(List<AdaptAdvancement> cachedAdvancements) {
        this.cachedAdvancements = cachedAdvancements;
    }

    public void setRecipes(List<AdaptRecipe> recipes) {
        this.recipes = recipes;
    }

    public void setBrewingRecipes(List<BrewingRecipe> brewingRecipes) {
        this.brewingRecipes = brewingRecipes;
    }

    public void setConfigType(Class<T> configType) {
        this.configType = configType;
    }

    public void setConfig(T config) {
        this.config = config;
    }

    public String toString() {
        return "SimpleAdaptation(maxLevel=" + this.getMaxLevel() + ", initialCost=" + this.getInitialCost() + ", baseCost=" + this.getBaseCost() + ", costFactor=" + this.getCostFactor() + ", displayName=" + this.getDisplayName() + ", skill=" + this.getSkill() + ", description=" + this.getDescription() + ", icon=" + this.getIcon() + ", name=" + this.getName() + ", cachedAdvancements=" + this.getCachedAdvancements() + ", recipes=" + this.getRecipes() + ", brewingRecipes=" + this.getBrewingRecipes() + ", configType=" + this.getConfigType() + ", config=" + this.getConfig() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

