/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.advancement;

import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.advancement.AdvancementDisplay;
import com.volmit.adapt.util.advancements.advancement.AdvancementFlag;
import com.volmit.adapt.util.advancements.advancement.AdvancementVisibility;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;

public class AdaptAdvancement {
    private String background;
    private Material icon;
    private String title;
    private String description;
    private AdvancementDisplay.AdvancementFrame frame;
    private boolean toast;
    private boolean announce;
    private AdvancementVisibility visibility;
    private String key;
    private List<AdaptAdvancement> children;

    public Advancement toAdvancement() {
        return this.toAdvancement(null, 0, 0);
    }

    public Advancement toAdvancement(Advancement parent, int index, int depth) {
        if (this.children == null) {
            this.children = new ArrayList<AdaptAdvancement>();
        }
        AdvancementDisplay d = new AdvancementDisplay(this.getIcon(), this.getTitle(), this.getDescription(), this.getFrame(), this.getVisibility());
        if (this.background != null) {
            d.setBackgroundTexture(this.getBackground());
        }
        d.setX(1.0f + (float)depth);
        d.setY(1.0f + (float)index);
        return new Advancement(parent, new NameKey("adapt", this.getKey()), d, new AdvancementFlag[0]);
    }

    public List<Advancement> toAdvancements() {
        return this.toAdvancements(null, 0, 0);
    }

    public List<Advancement> toAdvancements(Advancement p, int index, int depth) {
        ArrayList<Advancement> aa = new ArrayList<Advancement>();
        Advancement a = this.toAdvancement(p, index, depth);
        boolean ind = false;
        if (this.children != null && !this.children.isEmpty()) {
            for (AdaptAdvancement i : this.children) {
                aa.addAll(i.toAdvancements(a, aa.size(), depth + 1));
            }
        }
        aa.add(a);
        return aa;
    }

    private static Material $default$icon() {
        return Material.EMERALD;
    }

    private static String $default$title() {
        return "MISSING TITLE";
    }

    private static String $default$description() {
        return "MISSING DESCRIPTION";
    }

    private static AdvancementDisplay.AdvancementFrame $default$frame() {
        return AdvancementDisplay.AdvancementFrame.TASK;
    }

    private static boolean $default$toast() {
        return false;
    }

    private static boolean $default$announce() {
        return false;
    }

    private static AdvancementVisibility $default$visibility() {
        return AdvancementVisibility.PARENT_GRANTED;
    }

    private static String $default$key() {
        return "root";
    }

    AdaptAdvancement(String background, Material icon, String title, String description, AdvancementDisplay.AdvancementFrame frame, boolean toast, boolean announce, AdvancementVisibility visibility, String key, List<AdaptAdvancement> children) {
        this.background = background;
        this.icon = icon;
        this.title = title;
        this.description = description;
        this.frame = frame;
        this.toast = toast;
        this.announce = announce;
        this.visibility = visibility;
        this.key = key;
        this.children = children;
    }

    public static AdaptAdvancementBuilder builder() {
        return new AdaptAdvancementBuilder();
    }

    public String getBackground() {
        return this.background;
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public AdvancementDisplay.AdvancementFrame getFrame() {
        return this.frame;
    }

    public boolean isToast() {
        return this.toast;
    }

    public boolean isAnnounce() {
        return this.announce;
    }

    public AdvancementVisibility getVisibility() {
        return this.visibility;
    }

    public String getKey() {
        return this.key;
    }

    public List<AdaptAdvancement> getChildren() {
        return this.children;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFrame(AdvancementDisplay.AdvancementFrame frame) {
        this.frame = frame;
    }

    public void setToast(boolean toast) {
        this.toast = toast;
    }

    public void setAnnounce(boolean announce) {
        this.announce = announce;
    }

    public void setVisibility(AdvancementVisibility visibility) {
        this.visibility = visibility;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setChildren(List<AdaptAdvancement> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaptAdvancement)) {
            return false;
        }
        AdaptAdvancement other = (AdaptAdvancement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isToast() != other.isToast()) {
            return false;
        }
        if (this.isAnnounce() != other.isAnnounce()) {
            return false;
        }
        String this$background = this.getBackground();
        String other$background = other.getBackground();
        if (this$background == null ? other$background != null : !this$background.equals(other$background)) {
            return false;
        }
        Material this$icon = this.getIcon();
        Material other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        AdvancementDisplay.AdvancementFrame this$frame = this.getFrame();
        AdvancementDisplay.AdvancementFrame other$frame = other.getFrame();
        if (this$frame == null ? other$frame != null : !((Object)((Object)this$frame)).equals((Object)other$frame)) {
            return false;
        }
        AdvancementVisibility this$visibility = this.getVisibility();
        AdvancementVisibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !this$visibility.equals(other$visibility)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<AdaptAdvancement> this$children = this.getChildren();
        List<AdaptAdvancement> other$children = other.getChildren();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaptAdvancement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isToast() ? 79 : 97);
        result = result * 59 + (this.isAnnounce() ? 79 : 97);
        String $background = this.getBackground();
        result = result * 59 + ($background == null ? 43 : $background.hashCode());
        Material $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        AdvancementDisplay.AdvancementFrame $frame = this.getFrame();
        result = result * 59 + ($frame == null ? 43 : ((Object)((Object)$frame)).hashCode());
        AdvancementVisibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : $visibility.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<AdaptAdvancement> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }

    public String toString() {
        return "AdaptAdvancement(background=" + this.getBackground() + ", icon=" + this.getIcon() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", frame=" + this.getFrame() + ", toast=" + this.isToast() + ", announce=" + this.isAnnounce() + ", visibility=" + this.getVisibility() + ", key=" + this.getKey() + ", children=" + this.getChildren() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class AdaptAdvancementBuilder {
        private String background;
        private boolean icon$set;
        private Material icon$value;
        private boolean title$set;
        private String title$value;
        private boolean description$set;
        private String description$value;
        private boolean frame$set;
        private AdvancementDisplay.AdvancementFrame frame$value;
        private boolean toast$set;
        private boolean toast$value;
        private boolean announce$set;
        private boolean announce$value;
        private boolean visibility$set;
        private AdvancementVisibility visibility$value;
        private boolean key$set;
        private String key$value;
        private ArrayList<AdaptAdvancement> children;

        AdaptAdvancementBuilder() {
        }

        public AdaptAdvancementBuilder background(String background) {
            this.background = background;
            return this;
        }

        public AdaptAdvancementBuilder icon(Material icon) {
            this.icon$value = icon;
            this.icon$set = true;
            return this;
        }

        public AdaptAdvancementBuilder title(String title) {
            this.title$value = title;
            this.title$set = true;
            return this;
        }

        public AdaptAdvancementBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public AdaptAdvancementBuilder frame(AdvancementDisplay.AdvancementFrame frame) {
            this.frame$value = frame;
            this.frame$set = true;
            return this;
        }

        public AdaptAdvancementBuilder toast(boolean toast) {
            this.toast$value = toast;
            this.toast$set = true;
            return this;
        }

        public AdaptAdvancementBuilder announce(boolean announce) {
            this.announce$value = announce;
            this.announce$set = true;
            return this;
        }

        public AdaptAdvancementBuilder visibility(AdvancementVisibility visibility) {
            this.visibility$value = visibility;
            this.visibility$set = true;
            return this;
        }

        public AdaptAdvancementBuilder key(String key) {
            this.key$value = key;
            this.key$set = true;
            return this;
        }

        public AdaptAdvancementBuilder child(AdaptAdvancement child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
            return this;
        }

        public AdaptAdvancementBuilder children(Collection<? extends AdaptAdvancement> children) {
            if (children == null) {
                throw new NullPointerException("children cannot be null");
            }
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.addAll(children);
            return this;
        }

        public AdaptAdvancementBuilder clearChildren() {
            if (this.children != null) {
                this.children.clear();
            }
            return this;
        }

        public AdaptAdvancement build() {
            List<AdaptAdvancement> children = switch (this.children == null ? 0 : this.children.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.children.get(0));
                default -> Collections.unmodifiableList(new ArrayList<AdaptAdvancement>(this.children));
            };
            Material icon$value = this.icon$value;
            if (!this.icon$set) {
                icon$value = AdaptAdvancement.$default$icon();
            }
            String title$value = this.title$value;
            if (!this.title$set) {
                title$value = AdaptAdvancement.$default$title();
            }
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = AdaptAdvancement.$default$description();
            }
            AdvancementDisplay.AdvancementFrame frame$value = this.frame$value;
            if (!this.frame$set) {
                frame$value = AdaptAdvancement.$default$frame();
            }
            boolean toast$value = this.toast$value;
            if (!this.toast$set) {
                toast$value = AdaptAdvancement.$default$toast();
            }
            boolean announce$value = this.announce$value;
            if (!this.announce$set) {
                announce$value = AdaptAdvancement.$default$announce();
            }
            AdvancementVisibility visibility$value = this.visibility$value;
            if (!this.visibility$set) {
                visibility$value = AdaptAdvancement.$default$visibility();
            }
            String key$value = this.key$value;
            if (!this.key$set) {
                key$value = AdaptAdvancement.$default$key();
            }
            return new AdaptAdvancement(this.background, icon$value, title$value, description$value, frame$value, toast$value, announce$value, visibility$value, key$value, children);
        }

        public String toString() {
            return "AdaptAdvancement.AdaptAdvancementBuilder(background=" + this.background + ", icon$value=" + this.icon$value + ", title$value=" + this.title$value + ", description$value=" + this.description$value + ", frame$value=" + this.frame$value + ", toast$value=" + this.toast$value + ", announce$value=" + this.announce$value + ", visibility$value=" + this.visibility$value + ", key$value=" + this.key$value + ", children=" + this.children + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

