/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.item;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.util.BukkitGson;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public interface DataItem<T> {
    public Material getMaterial();

    public Class<T> getType();

    public void applyLore(T var1, List<String> var2);

    public void applyMeta(T var1, ItemMeta var2);

    default public ItemStack blank() {
        return new ItemStack(this.getMaterial());
    }

    default public T getData(ItemStack stack) {
        String r;
        if (stack != null && stack.getType().equals((Object)this.getMaterial()) && stack.getItemMeta() != null && (r = (String)stack.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)Adapt.instance, "" + this.getType().getCanonicalName().hashCode()), PersistentDataType.STRING)) != null) {
            return (T)BukkitGson.gson.fromJson(r, this.getType());
        }
        return null;
    }

    default public void setData(ItemStack item, T t) {
        item.setItemMeta(this.withData(t).getItemMeta());
    }

    default public ItemStack withData(T t) {
        ItemStack item = this.blank();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        this.applyMeta(t, meta);
        ArrayList<String> lore = new ArrayList<String>();
        this.applyLore(t, lore);
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)Adapt.instance, "" + this.getType().getCanonicalName().hashCode()), PersistentDataType.STRING, (Object)BukkitGson.gson.toJson(t));
        item.setItemMeta(meta);
        return item;
    }
}

