/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.skill;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.potion.BrewingManager;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.content.skill.SkillAgility;
import com.volmit.adapt.content.skill.SkillArchitect;
import com.volmit.adapt.content.skill.SkillAxes;
import com.volmit.adapt.content.skill.SkillBlocking;
import com.volmit.adapt.content.skill.SkillBrewing;
import com.volmit.adapt.content.skill.SkillChronos;
import com.volmit.adapt.content.skill.SkillCrafting;
import com.volmit.adapt.content.skill.SkillDiscovery;
import com.volmit.adapt.content.skill.SkillEnchanting;
import com.volmit.adapt.content.skill.SkillExcavation;
import com.volmit.adapt.content.skill.SkillHerbalism;
import com.volmit.adapt.content.skill.SkillHunter;
import com.volmit.adapt.content.skill.SkillNether;
import com.volmit.adapt.content.skill.SkillPickaxes;
import com.volmit.adapt.content.skill.SkillRanged;
import com.volmit.adapt.content.skill.SkillRift;
import com.volmit.adapt.content.skill.SkillSeaborne;
import com.volmit.adapt.content.skill.SkillStealth;
import com.volmit.adapt.content.skill.SkillSwords;
import com.volmit.adapt.content.skill.SkillTaming;
import com.volmit.adapt.content.skill.SkillTragOul;
import com.volmit.adapt.content.skill.SkillUnarmed;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class SkillRegistry
extends TickedObject {
    public static final Map<String, Skill<?>> skills;

    public SkillRegistry() {
        super("registry", UUID.randomUUID() + "-sk", 1250L);
        this.registerSkill(SkillAgility.class);
        this.registerSkill(SkillArchitect.class);
        this.registerSkill(SkillAxes.class);
        this.registerSkill(SkillBlocking.class);
        this.registerSkill(SkillChronos.class);
        this.registerSkill(SkillCrafting.class);
        this.registerSkill(SkillDiscovery.class);
        this.registerSkill(SkillEnchanting.class);
        this.registerSkill(SkillHerbalism.class);
        this.registerSkill(SkillHunter.class);
        this.registerSkill(SkillPickaxes.class);
        this.registerSkill(SkillRanged.class);
        this.registerSkill(SkillRift.class);
        this.registerSkill(SkillSeaborne.class);
        this.registerSkill(SkillStealth.class);
        this.registerSkill(SkillSwords.class);
        this.registerSkill(SkillTaming.class);
        this.registerSkill(SkillTragOul.class);
        this.registerSkill(SkillUnarmed.class);
        this.registerSkill(SkillExcavation.class);
        this.registerSkill(SkillBrewing.class);
        this.registerSkill(SkillNether.class);
    }

    @EventHandler
    public void on(PlayerExpChangeEvent e) {
        Player p = e.getPlayer();
        if (e.getAmount() > 0) {
            this.getPlayer(p).boostXPToRecents(0.03, 10000);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerInteractEvent e) {
        ItemStack it;
        boolean isAdaptActivator;
        Player p = e.getPlayer();
        boolean commonConditions = p.isSneaking() && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && e.getClickedBlock() != null;
        boolean isLectern = commonConditions && e.getClickedBlock().getType().equals((Object)Material.LECTERN);
        boolean isObserver = commonConditions && e.getClickedBlock().getType().equals((Object)Material.OBSERVER);
        boolean bl = isAdaptActivator = !(e.getBlockFace().equals((Object)BlockFace.UP) || e.getBlockFace().equals((Object)BlockFace.DOWN) || p.isSneaking() || !e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || e.getClickedBlock() == null || !e.getClickedBlock().getType().equals((Object)Material.valueOf((String)AdaptConfig.get().adaptActivatorBlock)) || !p.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR) && p.getInventory().getItemInMainHand().getType().isBlock() || !p.getInventory().getItemInOffHand().getType().equals((Object)Material.AIR) && p.getInventory().getItemInOffHand().getType().isBlock());
        if (isAdaptActivator) {
            e.getClickedBlock().getWorld().playSound(e.getClickedBlock().getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 0.5f, 0.72f);
            e.getClickedBlock().getWorld().playSound(e.getClickedBlock().getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 0.35f, 0.755f);
            SkillsGui.open(p);
            e.setCancelled(true);
            p.getWorld().spawnParticle(Particle.CRIT_MAGIC, e.getClickedBlock().getLocation().clone().add(0.5, 1.0, 0.5), 25, 0.0, 0.0, 0.0, 1.1);
            p.getWorld().spawnParticle(Particle.ENCHANTMENT_TABLE, e.getClickedBlock().getLocation().clone().add(0.5, 1.0, 0.5), 12, 0.0, 0.0, 0.0, 1.1);
        }
        if (isLectern && (it = p.getInventory().getItemInMainHand()).getItemMeta() != null && !it.getItemMeta().getPersistentDataContainer().getKeys().isEmpty()) {
            e.setCancelled(true);
            this.playDebug(p);
            it.getItemMeta().getPersistentDataContainer().getKeys().forEach(k -> Bukkit.getServer().getConsoleSender().sendMessage(k + " = " + (String)it.getItemMeta().getPersistentDataContainer().getOrDefault(k, PersistentDataType.STRING, (Object)"Not a String")));
        }
        if (isObserver && (it = p.getInventory().getItemInMainHand()).getType().equals((Object)Material.EXPERIENCE_BOTTLE)) {
            Object vv;
            e.setCancelled(true);
            Bukkit.getServer().getConsoleSender().sendMessage("   ");
            p.setCooldown(Material.ENCHANTED_BOOK, 3);
            AdaptPlayer a = this.getPlayer(p);
            this.playDebug(p);
            Object xv = a.getData().getMultiplier() - 1.0 > 0.0 ? "+" + Form.pc(a.getData().getMultiplier() - 1.0) : Form.pc(a.getData().getMultiplier() - 1.0);
            Bukkit.getServer().getConsoleSender().sendMessage("Global" + C.GRAY + ": " + C.GREEN + (String)xv);
            for (XPMultiplier xPMultiplier : a.getData().getMultipliers()) {
                vv = xPMultiplier.getMultiplier() > 0.0 ? "+" + Form.pc(xPMultiplier.getMultiplier()) : Form.pc(xPMultiplier.getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage(C.GREEN + "* " + (String)vv + C.GRAY + " for " + Form.duration(xPMultiplier.getGoodFor() - M.ms(), 0));
            }
            for (XPMultiplier xPMultiplier : Adapt.instance.getAdaptServer().getData().getMultipliers()) {
                vv = xPMultiplier.getMultiplier() > 0.0 ? "+" + Form.pc(xPMultiplier.getMultiplier()) : Form.pc(xPMultiplier.getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage(C.GREEN + "* " + (String)vv + C.GRAY + " for " + Form.duration(xPMultiplier.getGoodFor() - M.ms(), 0));
            }
            for (PlayerSkillLine playerSkillLine : XMap.v(a.getData().getSkillLines())) {
                Skill s = playerSkillLine.getRawSkill(a);
                Object v = playerSkillLine.getMultiplier() - a.getData().getMultiplier() > 0.0 ? "+" + Form.pc(playerSkillLine.getMultiplier() - a.getData().getMultiplier()) : Form.pc(playerSkillLine.getMultiplier() - a.getData().getMultiplier());
                Bukkit.getServer().getConsoleSender().sendMessage("  " + s.getDisplayName() + C.GRAY + ": " + s.getColor() + (String)v);
                for (XPMultiplier j : playerSkillLine.getMultipliers()) {
                    Object vv2 = j.getMultiplier() > 0.0 ? "+" + Form.pc(j.getMultiplier()) : Form.pc(j.getMultiplier());
                    Bukkit.getServer().getConsoleSender().sendMessage("  " + s.getShortName() + C.GRAY + " " + (String)vv2 + " for " + Form.duration(j.getGoodFor() - M.ms(), 0));
                }
            }
        }
    }

    private void playDebug(Player p) {
        p.playSound(p.getLocation(), Sound.BLOCK_BELL_RESONATE, 1.0f, 0.6f);
        p.playSound(p.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 0.1f);
        p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.6f);
        p.playSound(p.getLocation(), Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.2f);
    }

    public Skill<?> getSkill(String i) {
        return skills.get(i);
    }

    public List<Skill<?>> getSkills() {
        return XMap.v(skills);
    }

    public void registerSkill(Class<? extends Skill<?>> skill) {
        try {
            Skill<?> sk = skill.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!sk.isEnabled()) {
                return;
            }
            skills.put(sk.getName(), sk);
            this.registerRecipes(sk);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void unregisterRecipes(Skill<?> s) {
        s.getRecipes().forEach(AdaptRecipe::unregister);
        s.getAdaptations().forEach(i -> i.getRecipes().forEach(AdaptRecipe::unregister));
    }

    private void registerRecipes(Skill<?> s) {
        s.getRecipes().forEach(AdaptRecipe::register);
        s.getAdaptations().forEach(i -> {
            i.getRecipes().forEach(AdaptRecipe::register);
            i.getBrewingRecipes().forEach(r -> BrewingManager.registerRecipe(i.getName(), r));
        });
    }

    @Override
    public void unregister() {
        for (Skill<?> i : XMap.v(skills)) {
            i.unregister();
            this.unregisterRecipes(i);
        }
    }

    @Override
    public void onTick() {
    }

    static {
        IBootstrap.dasBoot();
        skills = new ConcurrentHashMap();
    }
}

