/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.tick;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.tick.Ticked;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.event.Listener;

public abstract class TickedObject
implements Ticked,
Listener {
    private final AtomicLong lastTick;
    private final AtomicLong interval;
    private final AtomicInteger skip;
    private final AtomicInteger burst;
    private final AtomicLong ticks;
    private final AtomicInteger dieIn;
    private final AtomicBoolean die;
    private final long start;
    private final String group;
    private final String id;

    public TickedObject() {
        this("null");
    }

    public TickedObject(String group, String id) {
        this(group, id, 1000L);
    }

    public TickedObject(String group) {
        this(group, UUID.randomUUID().toString(), 1000L);
    }

    public TickedObject(String group, long interval) {
        this(group, UUID.randomUUID().toString(), interval);
    }

    public TickedObject(String group, String id, long interval) {
        this.group = group;
        this.id = id;
        this.die = new AtomicBoolean(false);
        this.dieIn = new AtomicInteger(0);
        this.interval = new AtomicLong(interval);
        this.lastTick = new AtomicLong(M.ms());
        this.burst = new AtomicInteger(0);
        this.skip = new AtomicInteger(0);
        this.ticks = new AtomicLong(0L);
        this.start = M.ms();
        Adapt.instance.getTicker().register(this);
        Adapt.instance.registerListener(this);
    }

    public void dieAfter(int ticks) {
        this.dieIn.set(ticks);
        this.die.set(true);
    }

    @Override
    public void unregister() {
        Adapt.instance.getTicker().unregister(this);
        Adapt.instance.unregisterListener(this);
    }

    @Override
    public long getLastTick() {
        return this.lastTick.get();
    }

    @Override
    public long getInterval() {
        if (this.burst.get() > 0) {
            return 0L;
        }
        return this.interval.get();
    }

    @Override
    public void setInterval(long ms) {
        this.interval.set(ms);
    }

    @Override
    public void tick() {
        if (this.skip.getAndDecrement() > 0) {
            return;
        }
        if (this.die.get() && this.dieIn.decrementAndGet() <= 0) {
            this.unregister();
            return;
        }
        this.lastTick.set(M.ms());
        this.burst.decrementAndGet();
        this.onTick();
    }

    public abstract void onTick();

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getTickCount() {
        return this.ticks.get();
    }

    @Override
    public long getAge() {
        return M.ms() - this.start;
    }

    @Override
    public boolean isBursting() {
        return this.burst.get() > 0;
    }

    @Override
    public void burst(int ticks) {
        if (this.burst.get() < 0) {
            this.burst.set(ticks);
            return;
        }
        this.burst.addAndGet(ticks);
    }

    @Override
    public boolean isSkipping() {
        return this.skip.get() > 0;
    }

    @Override
    public void stopBursting() {
        this.burst.set(0);
    }

    @Override
    public void stopSkipping() {
        this.skip.set(0);
    }

    @Override
    public void skip(int ticks) {
        if (this.skip.get() < 0) {
            this.skip.set(ticks);
            return;
        }
        this.skip.addAndGet(ticks);
    }

    static {
        IBootstrap.dasBoot();
    }
}

