/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.value;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.api.value.MaterialCount;
import com.volmit.adapt.api.value.MaterialRecipe;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.PrecisionStopwatch;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class MaterialValue {
    private static final Map<Material, Double> valueMultipliers;
    private static MaterialValue valueCache;
    private final Map<Material, Double> value = new HashMap<Material, Double>();

    public static void save() {
        if (valueCache == null) {
            return;
        }
        File l = Adapt.instance.getDataFile("data", "value-cache.json");
        try {
            IO.writeAll(l, new JSONObject(new Gson().toJson((Object)valueCache)).toString(4));
        }
        catch (IOException e) {
            Adapt.verbose("Failed to save value cache");
        }
    }

    public static MaterialValue get() {
        if (valueCache == null) {
            MaterialValue dummy = new MaterialValue();
            File l = Adapt.instance.getDataFile("data", "value-cache.json");
            if (!l.exists()) {
                try {
                    IO.writeAll(l, new JSONObject(new Gson().toJson((Object)dummy)).toString(4));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    valueCache = dummy;
                    return dummy;
                }
            }
            try {
                valueCache = (MaterialValue)new Gson().fromJson(IO.readAll(l), MaterialValue.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                valueCache = new MaterialValue();
            }
        }
        return valueCache;
    }

    public static void debugValue(Material m) {
        MaterialValue.debugValue(m, 0, 1, new HashSet<MaterialRecipe>());
    }

    private static void debugValue(Material m, int ind, int x, Set<MaterialRecipe> ignore) {
        PrecisionStopwatch p = PrecisionStopwatch.start();
        Adapt.verbose(Form.repeat("  ", ind) + m.name() + ": " + MaterialValue.getValue(m) + (String)(x == 1 ? "" : " (x" + x + ")"));
        int r = 0;
        for (MaterialRecipe i : MaterialValue.getRecipes(m)) {
            if (ignore.contains(i)) continue;
            ignore.add(i);
            if (ignore.size() > AdaptConfig.get().getMaxRecipeListPrecaution()) {
                Adapt.verbose("Avoiding infinite loop");
                return;
            }
            int o = i.getOutput().getAmount();
            Adapt.verbose(Form.repeat("  ", ind) + "# Recipe [" + ind + "x" + r + (String)(o == 1 ? "]" : "] (x" + o + ") "));
            for (MaterialCount j : i.getInput()) {
                MaterialValue.debugValue(j.getMaterial(), ind + 1, j.getAmount(), ignore);
            }
            ++r;
        }
        Adapt.verbose(Form.repeat("  ", ind) + " took " + Form.duration(p.getMilliseconds(), 0));
    }

    private static double getMultiplier(Material m) {
        Double d = AdaptConfig.get().getValue().getValueMutlipliers().get(m);
        return d == null ? 1.0 : d;
    }

    public static double getValue(Material m) {
        try {
            return MaterialValue.getValue(m, new HashSet<MaterialRecipe>());
        }
        catch (Exception ignored) {
            return 1.0;
        }
    }

    private static double getValue(Material m, Set<MaterialRecipe> ignore) {
        if (MaterialValue.get().value.containsKey(m)) {
            if (m.isBlock() && m.getHardness() == 0.0f) {
                return 0.0;
            }
            return MaterialValue.get().value.get(m);
        }
        double v = AdaptConfig.get().getValue().getBaseValue();
        List<MaterialRecipe> recipes = MaterialValue.getRecipes(m);
        if (recipes.isEmpty()) {
            MaterialValue.get().value.put(m, v * MaterialValue.getMultiplier(m));
        } else {
            ArrayList<Double> d = new ArrayList<Double>();
            for (MaterialRecipe i2 : recipes) {
                if (ignore.contains(i2)) continue;
                ignore.add(i2);
                double vx = v;
                for (MaterialCount j : i2.getInput()) {
                    vx += MaterialValue.getValue(j.getMaterial(), ignore);
                }
                d.add(vx / (double)i2.getOutput().getAmount());
            }
            if (d.size() > 0) {
                v += d.stream().mapToDouble(i -> i).average().getAsDouble();
            }
            if (v > (double)AdaptConfig.get().getMaxRecipeListPrecaution()) {
                MaterialValue.get().value.put(m, (v / 10.0 + 1.0) * MaterialValue.getMultiplier(m));
            } else {
                MaterialValue.get().value.put(m, v);
            }
        }
        if (m.isBlock() && m.getHardness() == 0.0f) {
            return 0.0;
        }
        return MaterialValue.get().value.get(m);
    }

    private static List<MaterialRecipe> getRecipes(Material mat) {
        ArrayList<MaterialRecipe> r = new ArrayList<MaterialRecipe>();
        try {
            ItemStack is = new ItemStack(mat);
            try {
                is.setDurability((short)-1);
            }
            catch (Throwable e) {
                Adapt.verbose("Failed to set durability of " + mat.name());
            }
            Bukkit.getRecipesFor((ItemStack)is).forEach(i -> {
                if (i instanceof AdaptRecipe) {
                    Adapt.verbose("Skipping Adapt Recipe to prevent duplicates, " + mat.name() + " -> " + ((AdaptRecipe)i).getKey());
                    return;
                }
                MaterialRecipe rx = MaterialValue.toMaterial(i);
                if (rx != null) {
                    r.add(rx);
                }
            });
        }
        catch (Throwable e) {
            Adapt.verbose("Failed to get recipes for " + mat.name());
        }
        return r;
    }

    private static MaterialRecipe toMaterial(Recipe r) {
        try {
            if (r instanceof ShapelessRecipe) {
                ShapelessRecipe recipe = (ShapelessRecipe)r;
                return MaterialRecipe.builder().input(new ArrayList<MaterialCount>(recipe.getIngredientList().stream().map(i -> new MaterialCount(i.getType(), 1)).toList())).output(new MaterialCount(recipe.getResult().getType(), recipe.getResult().getAmount())).build();
            }
            if (r instanceof ShapedRecipe) {
                ShapedRecipe recipe = (ShapedRecipe)r;
                MaterialRecipe re = MaterialRecipe.builder().input(new ArrayList<MaterialCount>()).output(new MaterialCount(recipe.getResult().getType(), recipe.getResult().getAmount())).build();
                HashMap<Material, Integer> f = new HashMap<Material, Integer>();
                for (ItemStack i2 : recipe.getIngredientMap().values()) {
                    if (i2 == null || i2.getType().isAir()) continue;
                    f.compute(i2.getType(), (k, v) -> v == null ? 1 : v + 1);
                }
                f.forEach((k, v) -> re.getInput().add(new MaterialCount((Material)k, (int)v)));
                return re;
            }
            if (r instanceof CookingRecipe) {
                CookingRecipe recipe = (CookingRecipe)r;
                ArrayList<MaterialCount> a = new ArrayList<MaterialCount>();
                a.add(new MaterialCount(recipe.getInput().getType(), 1));
                return MaterialRecipe.builder().input(a).output(new MaterialCount(recipe.getResult().getType(), recipe.getResult().getAmount())).build();
            }
            if (r instanceof MerchantRecipe) {
                MerchantRecipe recipe = (MerchantRecipe)r;
                return MaterialRecipe.builder().input(new ArrayList<MaterialCount>(recipe.getIngredients().stream().map(i -> new MaterialCount(i.getType(), 1)).toList())).output(new MaterialCount(recipe.getResult().getType(), recipe.getResult().getAmount())).build();
            }
            if (r instanceof StonecuttingRecipe) {
                StonecuttingRecipe recipe = (StonecuttingRecipe)r;
                ArrayList<MaterialCount> a = new ArrayList<MaterialCount>();
                a.add(new MaterialCount(recipe.getInput().getType(), 1));
                return MaterialRecipe.builder().input(a).output(new MaterialCount(recipe.getResult().getType(), recipe.getResult().getAmount())).build();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map<Material, Double> getValue() {
        return this.value;
    }

    static {
        IBootstrap.dasBoot();
        valueMultipliers = new HashMap<Material, Double>();
        valueCache = null;
        AdaptConfig.get().getValue().getValueMutlipliers().forEach((k, v) -> {
            try {
                Material m = Material.valueOf((String)k.toUpperCase());
                valueMultipliers.put(m, (Double)v);
            }
            catch (Exception e) {
                Adapt.verbose("Invalid material value multiplier: " + k);
            }
        });
    }
}

