/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.google.gson.Gson;
import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.Adaptation;
import com.volmit.adapt.api.notification.AdvancementNotification;
import com.volmit.adapt.api.notification.SoundNotification;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.skill.SkillRegistry;
import com.volmit.adapt.api.tick.TickedObject;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.AdaptServerData;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.api.xp.SpatialXP;
import com.volmit.adapt.api.xp.XP;
import com.volmit.adapt.api.xp.XPMultiplier;
import com.volmit.adapt.content.gui.SkillsGui;
import com.volmit.adapt.content.item.ExperienceOrb;
import com.volmit.adapt.content.item.KnowledgeOrb;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.IO;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.JSONObject;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class AdaptServer
extends TickedObject {
    private final Map<Player, AdaptPlayer> players;
    private final List<SpatialXP> spatialTickets;
    private SkillRegistry skillRegistry;
    private AdaptServerData data = new AdaptServerData();

    public AdaptServer() {
        super("core", UUID.randomUUID().toString(), 1000L);
        this.spatialTickets = new ArrayList<SpatialXP>();
        this.players = new HashMap<Player, AdaptPlayer>();
        this.load();
        this.skillRegistry = new SkillRegistry();
        Bukkit.getOnlinePlayers().forEach(this::join);
    }

    public void offer(SpatialXP xp) {
        if (xp == null || xp.getSkill() == null || xp.getRadius() > 0.0 || xp.getMs() > 0L || xp.getLocation() == null) {
            return;
        }
        this.spatialTickets.add(xp);
    }

    public void takeSpatial(AdaptPlayer p) {
        J.attempt(() -> {
            double c;
            Optional optX = this.spatialTickets.stream().findAny();
            if (optX.isEmpty()) {
                return;
            }
            SpatialXP x = (SpatialXP)optX.get();
            if (M.ms() > x.getMs()) {
                this.spatialTickets.remove(x);
                return;
            }
            if (!p.getPlayer().getClass().getSimpleName().equals("CraftPlayer")) {
                this.spatialTickets.remove(x);
                return;
            }
            if (p.getPlayer().getWorld().equals(x.getLocation().getWorld()) && (c = p.getPlayer().getLocation().distanceSquared(x.getLocation())) < x.getRadius() * x.getRadius()) {
                double distl = M.lerpInverse(0.0, x.getRadius() * x.getRadius(), c);
                double xp = x.getXp() / (1.5 * (distl * 9.0 + 1.0));
                x.setXp(x.getXp() - xp);
                if (x.getXp() < 10.0) {
                    xp += x.getXp();
                    this.spatialTickets.remove(x);
                }
                XP.xp(p, x.getSkill(), xp);
            }
        });
    }

    public void join(Player p) {
        AdaptPlayer a = new AdaptPlayer(p);
        this.players.put(p, a);
        a.loggedIn();
    }

    public void quit(Player p) {
        Optional.ofNullable(this.players.remove(p)).ifPresent(AdaptPlayer::unregister);
    }

    @Override
    public void unregister() {
        new HashSet<Player>(this.players.keySet()).forEach(this::quit);
        this.skillRegistry.unregister();
        this.save();
        super.unregister();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(ProjectileLaunchEvent e) {
        Projectile projectile = e.getEntity();
        if (projectile instanceof Snowball) {
            Snowball s = (Snowball)projectile;
            projectile = e.getEntity().getShooter();
            if (projectile instanceof Player) {
                Player p = (Player)projectile;
                KnowledgeOrb.Data data = KnowledgeOrb.get(s.getItem());
                if (data != null) {
                    Skill<?> skill = this.getSkillRegistry().getSkill(data.getSkill());
                    data.apply(p);
                    SoundNotification.builder().sound(Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM).volume(0.35f).pitch(1.455f).build().play(this.getPlayer(p));
                    SoundNotification.builder().sound(Sound.ENTITY_SHULKER_OPEN).volume(1.0f).pitch(1.655f).build().play(this.getPlayer(p));
                    this.getPlayer(p).getNot().queue(AdvancementNotification.builder().icon(Material.BOOK).title(C.GRAY + "+ " + C.WHITE + data.getKnowledge() + " " + skill.getDisplayName() + " Knowledge").build());
                    e.setCancelled(false);
                    e.getEntity().setVelocity(e.getEntity().getVelocity().multiply(1000));
                } else {
                    ExperienceOrb.Data datax = ExperienceOrb.get(s.getItem());
                    if (datax != null) {
                        datax.apply(p);
                        SoundNotification.builder().sound(Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM).volume(0.35f).pitch(1.455f).build().play(this.getPlayer(p));
                        SoundNotification.builder().sound(Sound.ENTITY_SHULKER_OPEN).volume(1.0f).pitch(1.655f).build().play(this.getPlayer(p));
                        e.setCancelled(false);
                        e.getEntity().setVelocity(e.getEntity().getVelocity().multiply(1000));
                    }
                }
            }
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.join(p);
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.quit(p);
    }

    @EventHandler
    public void on(CraftItemEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            for (Skill skill : this.getSkillRegistry().getSkills()) {
                for (Adaptation<?> j : skill.getAdaptations()) {
                    if (!j.isAdaptationRecipe(e.getRecipe()) || j.hasAdaptation(p)) continue;
                    Adapt.actionbar(p, C.RED + "Requires " + j.getDisplayName() + C.RED + " from " + skill.getDisplayName());
                    p.playSound(p.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 0.5f, 1.8f);
                    e.setCancelled(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTick() {
        List<SpatialXP> list = this.spatialTickets;
        synchronized (list) {
            for (int i = 0; i < this.spatialTickets.size(); ++i) {
                if (M.ms() <= this.spatialTickets.get(i).getMs()) continue;
                this.spatialTickets.remove(i);
            }
        }
    }

    public PlayerData peekData(UUID player) {
        String sqlData;
        if (Bukkit.getPlayer((UUID)player) != null) {
            return this.getPlayer(Bukkit.getPlayer((UUID)player)).getData();
        }
        if (Adapt.instance.getSqlManager().useSql() && (sqlData = Adapt.instance.getSqlManager().fetchData(player)) != null) {
            return (PlayerData)new Gson().fromJson(sqlData, PlayerData.class);
        }
        File f = new File(Adapt.instance.getDataFolder("data", "players"), player + ".json");
        if (f.exists()) {
            try {
                return (PlayerData)new Gson().fromJson(IO.readAll(f), PlayerData.class);
            }
            catch (Throwable ignored) {
                Adapt.verbose("Failed to load player data for " + player);
            }
        }
        return new PlayerData();
    }

    @Override
    public AdaptPlayer getPlayer(Player p) {
        return this.players.get(p);
    }

    public void openSkillGUI(Skill<?> skill, Player p) {
        skill.openGui(p);
    }

    public void openAdaptGui(Player p) {
        SkillsGui.open(p);
    }

    public void openAdaptationGUI(Adaptation<?> adaptation, Player p) {
        adaptation.openGui(p);
    }

    public void boostXP(double boost, int ms) {
        this.data.getMultipliers().add(new XPMultiplier(boost, ms));
    }

    public void load() {
        File f = new File(Adapt.instance.getDataFolder("data"), "server-data.json");
        if (f.exists()) {
            try {
                String text = IO.readAll(f);
                this.data = (AdaptServerData)new Gson().fromJson(text, AdaptServerData.class);
            }
            catch (Throwable ignored) {
                Adapt.verbose("Failed to load global boosts data");
            }
        }
    }

    public void save() {
        IO.writeAll(new File(Adapt.instance.getDataFolder("data"), "server-data.json"), new JSONObject(this.data).toString(4));
    }

    public List<SpatialXP> getSpatialTickets() {
        return this.spatialTickets;
    }

    public SkillRegistry getSkillRegistry() {
        return this.skillRegistry;
    }

    public AdaptServerData getData() {
        return this.data;
    }

    static {
        IBootstrap.dasBoot();
    }
}

