/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.util.manifold.rt.api.IBootstrap;

public class AdaptStatTracker {
    private String stat;
    private double goal;
    private double reward;
    private String advancement;

    AdaptStatTracker(String stat, double goal, double reward, String advancement) {
        this.stat = stat;
        this.goal = goal;
        this.reward = reward;
        this.advancement = advancement;
    }

    public static AdaptStatTrackerBuilder builder() {
        return new AdaptStatTrackerBuilder();
    }

    public String getStat() {
        return this.stat;
    }

    public double getGoal() {
        return this.goal;
    }

    public double getReward() {
        return this.reward;
    }

    public String getAdvancement() {
        return this.advancement;
    }

    public void setStat(String stat) {
        this.stat = stat;
    }

    public void setGoal(double goal) {
        this.goal = goal;
    }

    public void setReward(double reward) {
        this.reward = reward;
    }

    public void setAdvancement(String advancement) {
        this.advancement = advancement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaptStatTracker)) {
            return false;
        }
        AdaptStatTracker other = (AdaptStatTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getGoal(), other.getGoal()) != 0) {
            return false;
        }
        if (Double.compare(this.getReward(), other.getReward()) != 0) {
            return false;
        }
        String this$stat = this.getStat();
        String other$stat = other.getStat();
        if (this$stat == null ? other$stat != null : !this$stat.equals(other$stat)) {
            return false;
        }
        String this$advancement = this.getAdvancement();
        String other$advancement = other.getAdvancement();
        return !(this$advancement == null ? other$advancement != null : !this$advancement.equals(other$advancement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaptStatTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $goal = Double.doubleToLongBits(this.getGoal());
        result = result * 59 + (int)($goal >>> 32 ^ $goal);
        long $reward = Double.doubleToLongBits(this.getReward());
        result = result * 59 + (int)($reward >>> 32 ^ $reward);
        String $stat = this.getStat();
        result = result * 59 + ($stat == null ? 43 : $stat.hashCode());
        String $advancement = this.getAdvancement();
        result = result * 59 + ($advancement == null ? 43 : $advancement.hashCode());
        return result;
    }

    public String toString() {
        return "AdaptStatTracker(stat=" + this.getStat() + ", goal=" + this.getGoal() + ", reward=" + this.getReward() + ", advancement=" + this.getAdvancement() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class AdaptStatTrackerBuilder {
        private String stat;
        private double goal;
        private double reward;
        private String advancement;

        AdaptStatTrackerBuilder() {
        }

        public AdaptStatTrackerBuilder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public AdaptStatTrackerBuilder goal(double goal) {
            this.goal = goal;
            return this;
        }

        public AdaptStatTrackerBuilder reward(double reward) {
            this.reward = reward;
            return this;
        }

        public AdaptStatTrackerBuilder advancement(String advancement) {
            this.advancement = advancement;
            return this;
        }

        public AdaptStatTracker build() {
            return new AdaptStatTracker(this.stat, this.goal, this.reward, this.advancement);
        }

        public String toString() {
            return "AdaptStatTracker.AdaptStatTrackerBuilder(stat=" + this.stat + ", goal=" + this.goal + ", reward=" + this.reward + ", advancement=" + this.advancement + ")";
        }

        static {
            IBootstrap.dasBoot();
        }
    }
}

