/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.world;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.advancement.AdaptAdvancement;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.advancements.NameKey;
import com.volmit.adapt.util.advancements.advancement.Advancement;
import com.volmit.adapt.util.advancements.manager.AdvancementManager;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;

public class AdvancementHandler {
    private AdvancementManager manager;
    private AdaptPlayer player;
    private Map<Skill<?>, AdaptAdvancement> roots;
    private Map<String, Advancement> real;
    private boolean ready;

    public AdvancementHandler(AdaptPlayer player) {
        this.player = player;
        this.manager = new AdvancementManager(new NameKey("adapt", player.getPlayer().getUniqueId().toString()), player.getPlayer());
        this.roots = new HashMap();
        this.real = new HashMap<String, Advancement>();
        this.ready = false;
    }

    public void activate() {
        if (!AdaptConfig.get().isAdvancements()) {
            return;
        }
        J.s(() -> {
            this.removeAllAdvancements();
            for (Skill<?> i : this.player.getServer().getSkillRegistry().getSkills()) {
                AdaptAdvancement aa = i.buildAdvancements();
                this.roots.put(i, aa);
                for (Advancement j : XList.reverse(aa.toAdvancements())) {
                    this.real.put(j.getName().getKey(), j);
                    try {
                        this.getManager().addAdvancement(j);
                    }
                    catch (Throwable e) {
                        Adapt.error("Failed to register advancement " + j.getName().getKey());
                        e.printStackTrace();
                    }
                }
                this.unlockExisting(aa);
                J.s(() -> {
                    this.ready = true;
                }, 40);
            }
        }, 20);
    }

    public void grant(String key, boolean toast) {
        this.getPlayer().getData().ensureGranted(key);
        try {
            J.s(() -> this.getManager().grantAdvancement(this.player.getPlayer(), this.real.get(key)), 5);
        }
        catch (Exception e) {
            Adapt.error("Failed to grant advancement " + key);
        }
        if (toast && this.getPlayer() != null && this.getPlayer().getPlayer() != null) {
            try {
                this.real.get(key).displayToast(this.getPlayer().getPlayer());
            }
            catch (Exception e) {
                Adapt.error("Failed to grant advancement " + key + " Reattaching!");
            }
        }
    }

    public void grant(String key) {
        this.grant(key, true);
    }

    private void unlockExisting(AdaptAdvancement aa) {
        if (aa.getChildren() != null) {
            for (AdaptAdvancement i : aa.getChildren()) {
                this.unlockExisting(i);
            }
        }
        if (this.getPlayer().getData().isGranted(aa.getKey())) {
            J.s(() -> this.grant(aa.getKey(), false), 20);
        }
    }

    public void deactivate() {
        this.removeAllAdvancements();
    }

    public void removeAllAdvancements() {
        for (Advancement i : this.getManager().getAdvancements()) {
            this.getManager().removeAdvancement(i);
        }
    }

    public AdvancementManager getManager() {
        return this.manager;
    }

    public AdaptPlayer getPlayer() {
        return this.player;
    }

    public Map<Skill<?>, AdaptAdvancement> getRoots() {
        return this.roots;
    }

    public Map<String, Advancement> getReal() {
        return this.real;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setManager(AdvancementManager manager) {
        this.manager = manager;
    }

    public void setPlayer(AdaptPlayer player) {
        this.player = player;
    }

    public void setRoots(Map<Skill<?>, AdaptAdvancement> roots) {
        this.roots = roots;
    }

    public void setReal(Map<String, Advancement> real) {
        this.real = real;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdvancementHandler)) {
            return false;
        }
        AdvancementHandler other = (AdvancementHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReady() != other.isReady()) {
            return false;
        }
        AdvancementManager this$manager = this.getManager();
        AdvancementManager other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
            return false;
        }
        AdaptPlayer this$player = this.getPlayer();
        AdaptPlayer other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !((Object)this$player).equals(other$player)) {
            return false;
        }
        Map<Skill<?>, AdaptAdvancement> this$roots = this.getRoots();
        Map<Skill<?>, AdaptAdvancement> other$roots = other.getRoots();
        if (this$roots == null ? other$roots != null : !((Object)this$roots).equals(other$roots)) {
            return false;
        }
        Map<String, Advancement> this$real = this.getReal();
        Map<String, Advancement> other$real = other.getReal();
        return !(this$real == null ? other$real != null : !((Object)this$real).equals(other$real));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdvancementHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReady() ? 79 : 97);
        AdvancementManager $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
        AdaptPlayer $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : ((Object)$player).hashCode());
        Map<Skill<?>, AdaptAdvancement> $roots = this.getRoots();
        result = result * 59 + ($roots == null ? 43 : ((Object)$roots).hashCode());
        Map<String, Advancement> $real = this.getReal();
        result = result * 59 + ($real == null ? 43 : ((Object)$real).hashCode());
        return result;
    }

    public String toString() {
        return "AdvancementHandler(manager=" + this.getManager() + ", player=" + this.getPlayer() + ", roots=" + this.getRoots() + ", real=" + this.getReal() + ", ready=" + this.isReady() + ")";
    }

    static {
        IBootstrap.dasBoot();
    }
}

