/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.xp;

import com.volmit.adapt.api.xp.NewtonCurve;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.function.Function;

public enum Curves {
    QLOG(Curves.resolved(level -> Math.pow(level, 2.0) * Math.log(level), xp -> Math.sqrt(xp / Math.log(xp)), 0.001)),
    ELIN(Curves.resolved(level -> 1000.0 * Math.exp(0.001 * level), xp -> Math.log(xp / 1000.0) / 0.001, 0.001)),
    CUBRT(Curves.resolved(level -> Math.pow(level, 0.3333333333333333), xp -> Math.pow(xp, 3.0), 0.001)),
    HYPER(Curves.resolved(level -> 1000.0 / (2.0 - level), xp -> 2.0 - 1000.0 / xp, 0.001)),
    SIGM(Curves.resolved(level -> 1000.0 / (1.0 + Math.exp(-0.01 * (level - 50.0))), xp -> 50.0 + Math.log(xp / (1000.0 - xp)) / -0.01, 0.001)),
    X1D2(Curves.resolved(level -> Math.pow(level, 1.2), xp -> Math.pow(xp, 0.8333333333333334), 0.001)),
    X1D5(Curves.resolved(level -> Math.pow(level, 1.5), xp -> Math.pow(xp, 0.6666666666666666), 0.001)),
    X2(Curves.resolved(level -> Math.pow(level, 2.0), xp -> Math.pow(xp, 0.5), 0.001)),
    X3(Curves.resolved(level -> Math.pow(level, 3.0), xp -> Math.pow(xp, 0.3333333333333333), 0.001)),
    X4(Curves.resolved(level -> Math.pow(level, 4.0), xp -> Math.pow(xp, 0.25), 0.001)),
    X5(Curves.resolved(level -> Math.pow(level, 5.0), xp -> Math.pow(xp, 0.2), 0.001)),
    X6(Curves.resolved(level -> Math.pow(level, 6.0), xp -> Math.pow(xp, 0.16666666666666666), 0.001)),
    X7(Curves.resolved(level -> Math.pow(level, 7.0), xp -> Math.pow(xp, 0.14285714285714285), 0.001)),
    L1K(Curves.resolved(level -> level * 1000.0, xp -> xp / 1000.0, 0.001)),
    L4K(Curves.resolved(level -> level * 4000.0, xp -> xp / 4000.0, 0.001)),
    L8K(Curves.resolved(level -> level * 8000.0, xp -> xp / 8000.0, 0.001)),
    L16K(Curves.resolved(level -> level * 16000.0, xp -> xp / 16000.0, 0.001)),
    SKYRIM(SkyrimNewtonCurve.create()),
    WOW(WOWNewtonCurve.create()),
    XL05L7(level -> (537.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL1L7(level -> (1337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL15L7(level -> (1837.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL2L7(level -> (2337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL3L7(level -> (3337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL4L7(level -> (4337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL5L7(level -> (5337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL6L7(level -> (6337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL7L7(level -> (7337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL8L7(level -> (8337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL9L7(level -> (9337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL20L7(level -> (20337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL40L7(level -> (40337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL80L7(level -> (80337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL160L7(level -> (160337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    XL100L7(level -> (1000337.0 * level + Math.pow(level * 0.95, Math.PI)) / 1.137),
    LINEAR_EXPONENTIAL_1(Curves.resolved(level -> 1000.0 * level + 100.0 * Math.pow(level, 2.0), xp -> {
        double a = 1000.0;
        double b = 100.0;
        return (-a + Math.sqrt(a * a + 4.0 * b * xp)) / (2.0 * b);
    }, 0.001)),
    LINEAR_EXPONENTIAL_2(Curves.resolved(level -> 2000.0 * level + 50.0 * Math.pow(level, 2.5), xp -> {
        double a = 2000.0;
        double b = 50.0;
        double lvl = (-a + Math.sqrt(a * a + 4.0 * b * xp)) / (2.0 * b);
        return Math.pow((xp - a * lvl) / b, 0.4);
    }, 0.001)),
    LINEAR_EXPONENTIAL_3(Curves.resolved(level -> 500.0 * level + 200.0 * Math.pow(level, 1.5), xp -> {
        double a = 500.0;
        double b = 200.0;
        double lvl = (-a + Math.sqrt(a * a + 4.0 * b * xp)) / (2.0 * b);
        return Math.pow((xp - a * lvl) / b, 0.6666666666666666);
    }, 0.001));

    private final NewtonCurve curve;

    private Curves(NewtonCurve curve) {
        this.curve = curve;
    }

    private static NewtonCurve resolved(final Function<Double, Double> xpForLevel, final Function<Double, Double> levelForXP, double maxError) {
        return new NewtonCurve(){

            @Override
            public double getXPForLevel(double level) {
                return (Double)xpForLevel.apply(level);
            }

            @Override
            public double computeLevelForXP(double xp, double maxError) {
                return (Double)levelForXP.apply(xp);
            }
        };
    }

    public NewtonCurve getCurve() {
        return this.curve;
    }

    static {
        IBootstrap.dasBoot();
    }

    public static class SkyrimNewtonCurve {
        public static NewtonCurve create() {
            Function<Double, Double> xpForLevel = level -> {
                double f = 0.0;
                int i = 1;
                while ((double)i < level) {
                    f += SkyrimNewtonCurve.getNextLevelCost(i);
                    ++i;
                }
                return f;
            };
            Function<Double, Double> levelForXP = xp -> {
                double currentLevel = 1.0;
                while (xp.compareTo(SkyrimNewtonCurve.getNextLevelCost(currentLevel)) >= 0) {
                    xp = xp - SkyrimNewtonCurve.getNextLevelCost(currentLevel);
                    currentLevel += 1.0;
                }
                return currentLevel;
            };
            return Curves.resolved(xpForLevel, levelForXP, 0.001);
        }

        private static double getNextLevelCost(double currentLevel) {
            return Math.pow(currentLevel - 1.0, 1.95) + 300.0;
        }

        static {
            IBootstrap.dasBoot();
        }
    }

    public class WOWNewtonCurve {
        public static NewtonCurve create() {
            Function<Double, Double> xpForLevel = level -> {
                double f = 0.0;
                int i = 1;
                while ((double)i < level) {
                    f += WOWNewtonCurve.getNextLevelCost(i);
                    ++i;
                }
                return f;
            };
            Function<Double, Double> levelForXP = xp -> {
                double currentLevel = 1.0;
                while (xp.compareTo(WOWNewtonCurve.getNextLevelCost(currentLevel)) >= 0) {
                    xp = xp - WOWNewtonCurve.getNextLevelCost(currentLevel);
                    currentLevel += 1.0;
                }
                return currentLevel;
            };
            return Curves.resolved(xpForLevel, levelForXP, 0.001);
        }

        private static double getNextLevelCost(double currentLevel) {
            return (8.0 * currentLevel + WOWNewtonCurve.getDiff(currentLevel)) * WOWNewtonCurve.getMXP(currentLevel) * WOWNewtonCurve.getDRF(currentLevel);
        }

        private static double getMXP(double currentLevel) {
            return 235.0 + 5.0 * currentLevel;
        }

        private static double getDRF(double currentLevel) {
            if (currentLevel >= 11.0 && currentLevel <= 27.0) {
                return 1.0 - (currentLevel - 10.0) / 100.0;
            }
            if (currentLevel >= 28.0 && currentLevel <= 59.0) {
                return 0.82;
            }
            return 1.0;
        }

        private static double getDiff(double currentLevel) {
            if (currentLevel <= 28.0) {
                return 0.0;
            }
            if (currentLevel == 29.0) {
                return 1.0;
            }
            if (currentLevel == 30.0) {
                return 3.0;
            }
            if (currentLevel == 31.0) {
                return 6.0;
            }
            return 5.0 * (Math.min(currentLevel, 59.0) - 30.0);
        }
    }
}

