/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.api.xp;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.AdaptConfig;
import com.volmit.adapt.api.skill.Skill;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.api.xp.SpatialXP;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class XP {
    public static void xp(Player p, Skill skill, double xp) {
        XP.xp(Adapt.instance.getAdaptServer().getPlayer(p), skill, xp);
    }

    public static void xp(AdaptPlayer p, Skill skill, double xp) {
        PlayerSkillLine skillLine = p.getSkillLine(skill.getName());
        if (skillLine != null) {
            skillLine.giveXP(p.getNot(), xp);
        }
    }

    public static void xpSilent(Player p, Skill skill, double xp) {
        XP.xpSilent(Adapt.instance.getAdaptServer().getPlayer(p), skill, xp);
    }

    public static void xpSilent(AdaptPlayer p, Skill skill, double xp) {
        if (p.getSkillLine(skill.getName()) != null) {
            p.getSkillLine(skill.getName()).giveXP(null, xp);
        }
    }

    public static void spatialXP(Location l, Skill skill, double xp, int rad, long duration) {
        Adapt.instance.getAdaptServer().offer(new SpatialXP(l, skill, xp, rad, duration));
    }

    public static void wisdom(Player p, long k) {
        XP.wisdom(Adapt.instance.getAdaptServer().getPlayer(p), k);
    }

    public static void wisdom(AdaptPlayer p, long k) {
        p.getData().setWisdom(p.getData().getWisdom() + k);
    }

    public static void knowledge(Player p, Skill skill, long k) {
        XP.knowledge(Adapt.instance.getAdaptServer().getPlayer(p), skill, k);
    }

    public static void knowledge(AdaptPlayer p, Skill skill, long k) {
        p.getSkillLine(skill.getName()).giveKnowledge(k);
    }

    public static void boostXP(Player p, Skill skill, double percentChange, int durationMS) {
        XP.boostXP(Adapt.instance.getAdaptServer().getPlayer(p), skill, percentChange, durationMS);
    }

    public static void boostXP(AdaptPlayer p, Skill skill, double percentChange, int durationMS) {
        p.getSkillLine(skill.getName()).boost(percentChange, durationMS);
    }

    public static double getXpUntilLevelUp(double xp) {
        double level = XP.getLevelForXp(xp);
        double xa = XP.getXpForLevel((int)level);
        double xb = XP.getXpForLevel((int)level + 1);
        return M.lerp(xb - xa, 0.0, level - (double)((int)level));
    }

    public static double getLevelProgress(double xp) {
        double level = XP.getLevelForXp(xp);
        return level - (double)((int)level);
    }

    public static double getXpForLevel(double level) {
        return AdaptConfig.get().getXpCurve().getCurve().getXPForLevel(level);
    }

    public static double getLevelForXp(double xp) {
        return AdaptConfig.get().getXpCurve().getCurve().computeLevelForXP(xp, 1.0E-6);
    }

    static {
        IBootstrap.dasBoot();
    }
}

