/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;

public class AgilityArmorUp
extends SimpleAdaptation<Config> {
    private final Map<Player, Integer> ticksRunning;

    public AgilityArmorUp() {
        super("agility-armor-up");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "armorup", "description"));
        this.setIcon(Material.IRON_CHESTPLATE);
        this.setDisplayName(Localizer.dLocalize("agility", "armorup", "name"));
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(350L);
        this.ticksRunning = new HashMap<Player, Integer>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getWindupArmor(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("agility", "armorup", "lore1"));
        v.addLore(C.YELLOW + "* " + Form.duration(this.getWindupTicks(this.getLevelPercent(level)) * 50.0, 1) + " " + C.GRAY + Localizer.dLocalize("agility", "armorup", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.ticksRunning.remove(p);
    }

    private double getWindupTicks(double factor) {
        return M.lerp(((Config)this.getConfig()).windupTicksSlowest, ((Config)this.getConfig()).windupTicksFastest, factor);
    }

    private double getWindupArmor(double factor) {
        return ((Config)this.getConfig()).windupArmorBase + factor * ((Config)this.getConfig()).windupArmorLevelMultiplier;
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            for (AttributeModifier j : p.getAttribute(Attribute.GENERIC_ARMOR).getModifiers()) {
                if (!j.getName().equals("adapt-armor-up")) continue;
                p.getAttribute(Attribute.GENERIC_ARMOR).removeModifier(j);
            }
            if (p.isSwimming() || p.isFlying() || p.isGliding() || p.isSneaking()) {
                this.ticksRunning.remove(p);
                return;
            }
            if (p.isSprinting() && this.hasAdaptation(p)) {
                this.ticksRunning.compute(p, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
                Integer tr = this.ticksRunning.get(p);
                if (tr == null || tr.compareTo(0) <= 0) continue;
                double factor = this.getLevelPercent(p);
                double ticksToMax = this.getWindupTicks(factor);
                double progress = Math.min(M.lerpInverse(0.0, ticksToMax, tr.intValue()), 1.0);
                double armorInc = M.lerp(0.0, this.getWindupArmor(factor), progress);
                if (((Config)this.getConfig()).showParticles) {
                    if (M.r(0.2 * progress)) {
                        p.getWorld().spawnParticle(Particle.END_ROD, p.getLocation(), 1);
                    }
                    if (M.r(0.25 * progress)) {
                        p.getWorld().spawnParticle(Particle.WAX_ON, p.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                p.getAttribute(Attribute.GENERIC_ARMOR).addModifier(new AttributeModifier("adapt-armor-up", armorInc * 10.0, AttributeModifier.Operation.ADD_NUMBER));
                continue;
            }
            this.ticksRunning.remove(p);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.65;
        int initialCost = 8;
        double windupTicksSlowest = 180.0;
        double windupTicksFastest = 60.0;
        double windupArmorBase = 0.22;
        double windupArmorLevelMultiplier = 0.525;

        static {
            IBootstrap.dasBoot();
        }
    }
}

