/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.util.Vector;

public class AgilityWallJump
extends SimpleAdaptation<Config> {
    private final Map<Player, Double> airjumps;

    public AgilityWallJump() {
        super("agility-wall-jump");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "walljump", "description"));
        this.setDisplayName(Localizer.dLocalize("agility", "walljump", "name"));
        this.setIcon(Material.LADDER);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(50L);
        this.airjumps = new HashMap<Player, Double>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + this.getMaxJumps(level) + C.GRAY + " " + Localizer.dLocalize("agility", "walljump", "lore1"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getJumpHeight(level), 0) + C.GRAY + " " + Localizer.dLocalize("agility", "walljump", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.airjumps.remove(p);
    }

    private int getMaxJumps(int level) {
        return (int)((double)level + (double)level / ((Config)this.getConfig()).maxJumpsLevelBonusDivisor);
    }

    private double getJumpHeight(int level) {
        return ((Config)this.getConfig()).jumpHeightBase + this.getLevelPercent(level) * ((Config)this.getConfig()).jumpHeightBonusLevelMultiplier;
    }

    @EventHandler
    public void on(PlayerMoveEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.airjumps.containsKey(p) && p.isOnGround() && !p.getLocation().getBlock().getRelative(BlockFace.DOWN).getBlockData().getMaterial().isAir()) {
            this.airjumps.remove(p);
        }
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            int level = this.getLevel(p);
            if (level <= 0) continue;
            Double j = this.airjumps.get(p);
            if (j != null && j - 0.25 >= (double)this.getMaxJumps(level)) {
                p.setGravity(true);
                continue;
            }
            if (p.isFlying() || !p.isSneaking() || (double)p.getFallDistance() < 0.3) {
                boolean jumped = false;
                if (!p.hasGravity() && (double)p.getFallDistance() > 0.45 && this.canStick(p)) {
                    Double d = j = Double.valueOf(j == null ? 0.0 : j);
                    j = j + 1.0;
                    if (j - 0.25 <= (double)this.getMaxJumps(level) && this.getStick(p) != null) {
                        jumped = true;
                        p.setVelocity(p.getVelocity().setY(this.getJumpHeight(level)));
                        if (((Config)this.getConfig()).showParticles) {
                            p.getWorld().spawnParticle(Particle.BLOCK_CRACK, p.getLocation().clone().add(0.0, 0.3, 0.0), 15, 0.1, 0.8, 0.1, 0.1, (Object)this.getStick(p).getBlockData());
                        }
                    }
                    this.xp(p, 2.0);
                    this.airjumps.put(p, j);
                }
                if (jumped || p.hasGravity()) continue;
                p.setGravity(true);
                p.getLocation().getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 0.439f);
                continue;
            }
            if (this.canStick(p)) {
                if (p.hasGravity()) {
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_LEATHER, 1.0f, 0.89f);
                    p.getLocation().getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_CHAIN, 1.0f, 1.39f);
                    if (((Config)this.getConfig()).showParticles && this.getStick(p) != null) {
                        p.getWorld().spawnParticle(Particle.BLOCK_CRACK, p.getLocation().clone().add(0.0, 0.3, 0.0), 15, 0.1, 0.2, 0.1, 0.1, (Object)this.getStick(p).getBlockData());
                    }
                }
                p.setGravity(false);
                Vector c = p.getVelocity();
                p.setVelocity(p.getVelocity().setY(c.getY() * 0.35 - 0.0025));
                Double vv = this.airjumps.get(p);
                vv = vv == null ? 0.0 : vv;
                vv = vv + 0.0127;
                this.airjumps.put(p, vv);
            }
            if (this.canStick(p) || p.hasGravity()) continue;
            p.setGravity(true);
        }
    }

    private boolean canStick(Player p) {
        for (Block i : this.getBlocks(p)) {
            if (!i.getBlockData().getMaterial().isSolid()) continue;
            Vector velocity = p.getVelocity();
            Vector shift = p.getLocation().subtract(i.getLocation().clone().add(0.5, 0.5, 0.5)).toVector();
            velocity.setX(velocity.getX() - shift.getX() / 16.0);
            velocity.setZ(velocity.getZ() - shift.getZ() / 16.0);
            p.setVelocity(velocity);
            return true;
        }
        return false;
    }

    private Block getStick(Player p) {
        this.getBlocks(p);
        for (Block i : this.getBlocks(p)) {
            if (!i.getBlockData().getMaterial().isSolid()) continue;
            return i;
        }
        return null;
    }

    private Block[] getBlocks(Player p) {
        return new Block[]{p.getLocation().getBlock().getRelative(BlockFace.NORTH), p.getLocation().getBlock().getRelative(BlockFace.SOUTH), p.getLocation().getBlock().getRelative(BlockFace.EAST), p.getLocation().getBlock().getRelative(BlockFace.WEST), p.getLocation().getBlock().getRelative(BlockFace.NORTH_EAST), p.getLocation().getBlock().getRelative(BlockFace.SOUTH_EAST), p.getLocation().getBlock().getRelative(BlockFace.NORTH_WEST), p.getLocation().getBlock().getRelative(BlockFace.SOUTH_WEST), p.getLocation().getBlock().getRelative(BlockFace.NORTH_EAST).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.SOUTH_EAST).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.NORTH_WEST).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.SOUTH_WEST).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.NORTH).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.EAST).getRelative(BlockFace.UP), p.getLocation().getBlock().getRelative(BlockFace.WEST).getRelative(BlockFace.UP)};
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.65;
        int maxLevel = 5;
        int initialCost = 8;
        double maxJumpsLevelBonusDivisor = 2.0;
        double jumpHeightBase = 0.625;
        double jumpHeightBonusLevelMultiplier = 0.225;

        static {
            IBootstrap.dasBoot();
        }
    }
}

