/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.agility;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;
import org.spigotmc.event.entity.EntityDismountEvent;
import org.spigotmc.event.entity.EntityMountEvent;

public class AgilityWindUp
extends SimpleAdaptation<Config> {
    private final Map<Player, Integer> ticksRunning;

    public AgilityWindUp() {
        super("agility-wind-up");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("agility", "windup", "description"));
        this.setDisplayName(Localizer.dLocalize("agility", "windup", "name"));
        this.setIcon(Material.POWERED_RAIL);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(120L);
        this.ticksRunning = new HashMap<Player, Integer>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getWindupSpeed(this.getLevelPercent(level)), 0) + C.GRAY + Localizer.dLocalize("agility", "windup", "lore1"));
        v.addLore(C.YELLOW + "* " + Form.duration(this.getWindupTicks(this.getLevelPercent(level)) * 50.0, 1) + C.GRAY + Localizer.dLocalize("agility", "windup", "lore2"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.ticksRunning.remove(p);
    }

    @EventHandler
    public void on(EntityMountEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.ticksRunning.remove(p);
        }
    }

    @EventHandler
    public void on(EntityDismountEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            this.ticksRunning.remove(p);
        }
    }

    private double getWindupTicks(double factor) {
        return M.lerp(((Config)this.getConfig()).windupTicksSlowest, ((Config)this.getConfig()).windupTicksFastest, factor);
    }

    private double getWindupSpeed(double factor) {
        return ((Config)this.getConfig()).windupSpeedBase + factor * ((Config)this.getConfig()).windupSpeedLevelMultiplier;
    }

    @Override
    public void onTick() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED) == null) {
                return;
            }
            try {
                for (AttributeModifier j : p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getModifiers()) {
                    if (!j.getName().equals("adapt-wind-up")) continue;
                    p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).removeModifier(j);
                }
            }
            catch (Exception e) {
                Adapt.verbose("Failed to remove windup modifier: " + e.getMessage());
            }
            if (p.isSwimming() || p.isFlying() || p.isGliding() || p.isSneaking()) {
                this.ticksRunning.remove(p);
                return;
            }
            if (p.isSprinting() && this.getLevel(p) > 0) {
                this.ticksRunning.compute(p, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    return v + 1;
                });
                Integer tr = this.ticksRunning.get(p);
                if (tr == null || tr.compareTo(0) <= 0) continue;
                double factor = this.getLevelPercent(p);
                double ticksToMax = this.getWindupTicks(factor);
                double progress = Math.min(M.lerpInverse(0.0, ticksToMax, tr.intValue()), 1.0);
                double speedIncrease = M.lerp(0.0, this.getWindupSpeed(factor), progress);
                if (((Config)this.getConfig()).showParticles) {
                    if (M.r(0.2 * progress)) {
                        p.getWorld().spawnParticle(Particle.LAVA, p.getLocation(), 1);
                    }
                    if (M.r(0.25 * progress)) {
                        p.getWorld().spawnParticle(Particle.FLAME, p.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).addModifier(new AttributeModifier("adapt-wind-up", speedIncrease, AttributeModifier.Operation.MULTIPLY_SCALAR_1));
                continue;
            }
            this.ticksRunning.remove(p);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 2;
        double costFactor = 0.65;
        int initialCost = 8;
        double windupTicksSlowest = 180.0;
        double windupTicksFastest = 60.0;
        double windupSpeedBase = 0.22;
        double windupSpeedLevelMultiplier = 0.225;

        static {
            IBootstrap.dasBoot();
        }
    }
}

