/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class ArchitectFoundation
extends SimpleAdaptation<Config> {
    private static final BlockData AIR;
    private static final BlockData BLOCK;
    private final Map<Player, Integer> blockPower;
    private final Map<Player, Long> cooldowns;
    private final Set<Player> active;
    private final Set<Block> activeBlocks;

    public ArchitectFoundation() {
        super("architect-foundation");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "foundation", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "foundation", "name"));
        this.setIcon(Material.TINTED_GLASS);
        this.setInterval(988L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.blockPower = new HashMap<Player, Integer>();
        this.cooldowns = new HashMap<Player, Long>();
        this.active = new HashSet<Player>();
        this.activeBlocks = new HashSet<Block>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("architect", "foundation", "lore1") + this.getBlockPower(this.getLevelPercent(level)) + C.GRAY + " " + Localizer.dLocalize("architect", "foundation", "lore2"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerMoveEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!p.isSneaking()) {
            return;
        }
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (!e.getFrom().getBlock().equals(e.getTo().getBlock())) {
            return;
        }
        if (!this.active.contains(p)) {
            return;
        }
        int power = this.blockPower.get(p);
        if (power <= 0) {
            return;
        }
        Location l = e.getTo();
        World world = l.getWorld();
        HashSet<Block> locs = new HashSet<Block>();
        locs.add(world.getBlockAt(l.clone().add(0.3, -1.0, -0.3)));
        locs.add(world.getBlockAt(l.clone().add(-0.3, -1.0, -0.3)));
        locs.add(world.getBlockAt(l.clone().add(0.3, -1.0, 0.3)));
        locs.add(world.getBlockAt(l.clone().add(-0.3, -1.0, 0.3)));
        for (Block b : locs) {
            if (this.addFoundation(b)) {
                this.xp(p, 3.0);
                --power;
            }
            if (power > 0) continue;
            break;
        }
        this.blockPower.put(p, power);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPistonExtendEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.getBlocks().forEach(b -> {
            if (this.activeBlocks.contains(b)) {
                Adapt.verbose("Cancelled Piston Extend on Adaptation Foundation Block");
                e.setCancelled(true);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPistonRetractEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.getBlocks().forEach(b -> {
            if (this.activeBlocks.contains(b)) {
                Adapt.verbose("Cancelled Piston Retract on Adaptation Foundation Block");
                e.setCancelled(true);
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockExplodeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (this.activeBlocks.contains(e.getBlock())) {
            Adapt.verbose("Cancelled Block Explosion on Adaptation Foundation Block");
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent e) {
        if (this.activeBlocks.contains(e.getBlock())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityExplodeEvent e) {
        if (e.isCancelled()) {
            return;
        }
        e.blockList().removeIf(this.activeBlocks::contains);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(PlayerToggleSneakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p) || p.getGameMode().equals((Object)GameMode.CREATIVE) || p.getGameMode().equals((Object)GameMode.SPECTATOR)) {
            return;
        }
        boolean ready = !this.hasCooldown(p);
        boolean active = this.active.contains(p);
        if (e.isSneaking() && ready && !active) {
            this.active.add(p);
            this.cooldowns.put(p, Long.MAX_VALUE);
        } else if (!e.isSneaking() && active) {
            this.active.remove(p);
            this.cooldowns.put(p, M.ms() + (long)((Config)this.getConfig()).cooldown);
            p.playSound(p.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 10.0f);
            p.playSound(p.getLocation(), Sound.BLOCK_SCULK_CATALYST_BREAK, 1.0f, 0.81f);
        }
    }

    public boolean addFoundation(Block block) {
        if (!block.getType().isAir()) {
            return false;
        }
        J.s(() -> {
            block.setBlockData(BLOCK);
            this.activeBlocks.add(block);
        });
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_DEEPSLATE_PLACE, 1.0f, 1.0f);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.REVERSE_PORTAL);
            this.vfxCuboidOutline(block, Particle.ASH);
        }
        J.a(() -> this.removeFoundation(block), 60);
        return true;
    }

    public void removeFoundation(Block block) {
        if (!block.getBlockData().equals(BLOCK)) {
            return;
        }
        J.s(() -> {
            block.setBlockData(AIR);
            this.activeBlocks.remove(block);
        });
        block.getWorld().playSound(block.getLocation(), Sound.BLOCK_DEEPSLATE_BREAK, 1.0f, 1.0f);
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(block, Particle.ENCHANTMENT_TABLE);
        }
    }

    public int getBlockPower(double factor) {
        return (int)Math.floor(M.lerp(((Config)this.getConfig()).minBlocks, ((Config)this.getConfig()).maxBlocks, factor));
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            if (!this.hasAdaptation(i)) continue;
            boolean ready = !this.hasCooldown(i);
            int availablePower = this.getBlockPower(this.getLevelPercent(i));
            this.blockPower.compute(i, (k, v) -> {
                if (k == null || v == null || ready && v != availablePower) {
                    if (i == null) {
                        return 0;
                    }
                    i.getWorld().playSound(i.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 10.0f);
                    i.getWorld().playSound(i.getLocation(), Sound.BLOCK_RESPAWN_ANCHOR_CHARGE, 1.0f, 0.81f);
                    return availablePower;
                }
                return v;
            });
        }
    }

    private boolean hasCooldown(Player i) {
        if (this.cooldowns.containsKey(i) && M.ms() >= this.cooldowns.get(i)) {
            this.cooldowns.remove(i);
        }
        return this.cooldowns.containsKey(i);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        AIR = Material.AIR.createBlockData();
        BLOCK = Material.TINTED_GLASS.createBlockData();
    }

    protected static class Config {
        public long duration = 3000L;
        public int minBlocks = 9;
        public int maxBlocks = 35;
        public int cooldown = 5000;
        boolean permanent = false;
        boolean showParticles = true;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 5;
        int initialCost = 1;
        double costFactor = 0.4;

        static {
            IBootstrap.dasBoot();
        }
    }
}

