/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class ArchitectGlass
extends SimpleAdaptation<Config> {
    public ArchitectGlass() {
        super("architect-glass");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "glass", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "glass", "name"));
        this.setIcon(Material.GLASS);
        this.setInterval(25000L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("architect", "glass", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!(!this.hasAdaptation(p) || p.getInventory().getItemInMainHand().getType() != Material.AIR && this.isTool(p.getInventory().getItemInMainHand()) || e.isCancelled() || !e.getBlock().getType().toString().contains("GLASS") || e.getBlock().getType().toString().contains("TINTED_GLASS"))) {
            e.getBlock().getWorld().dropItemNaturally(e.getBlock().getLocation(), new ItemStack(e.getBlock().getType(), 1));
            e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_LARGE_AMETHYST_BUD_BREAK, 1.0f, 1.0f);
            if (((Config)this.getConfig()).showParticles) {
                e.getBlock().getWorld().spawnParticle(Particle.SCRAPE, e.getBlock().getLocation(), 1);
                J.a(() -> this.vfxCuboidOutline(e.getBlock(), Particle.REVERSE_PORTAL));
            }
            e.getBlock().breakNaturally();
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = true;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        int maxLevel = 1;
        int initialCost = 0;
        double costFactor = 5.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

