/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.architect;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;

public class ArchitectPlacement
extends SimpleAdaptation<Config> {
    private final HashMap<Player, Map<Block, BlockFace>> totalMap = new HashMap();

    public ArchitectPlacement() {
        super("architect-placement");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("architect", "placement", "description"));
        this.setDisplayName(Localizer.dLocalize("architect", "placement", "name"));
        this.setIcon(Material.SCAFFOLDING);
        this.setInterval(360L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("architect", "placement", "lore3"));
    }

    private BlockFace getBlockFace(Player player) {
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(null, 5);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return null;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        Block adjacentBlock = (Block)lastTwoTargetBlocks.get(0);
        return targetBlock.getFace(adjacentBlock);
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.totalMap.remove(p);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockPlaceEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasAdaptation(p) && !this.totalMap.isEmpty() && this.totalMap.get(p) != null && this.totalMap.get(p).size() > 0) {
            ItemStack is = p.getInventory().getItemInMainHand().clone();
            ItemStack hand = p.getInventory().getItemInMainHand();
            if (p.isSneaking() && is.getType().isBlock()) {
                double v = this.getValue(e.getBlock());
                int handSizeAfter = is.getAmount() - this.totalMap.get(p).size();
                if (handSizeAfter >= 0) {
                    for (Block b : this.totalMap.get(p).keySet()) {
                        if (!this.canBlockPlace(p, b.getLocation())) {
                            Adapt.verbose("Player " + p.getName() + " doesn't have permission.");
                            continue;
                        }
                        BlockFace face = this.totalMap.get(p).get(b);
                        if (b.getWorld().getBlockAt(b.getRelative(face).getLocation()).getType() == Material.AIR && b.getRelative(face).getLocation() != e.getBlock().getLocation()) {
                            b.getWorld().setBlockData(b.getRelative(face).getLocation(), b.getBlockData());
                            this.getPlayer(p).getData().addStat("blocks.placed", 1.0);
                            this.getPlayer(p).getData().addStat("blocks.placed.value", v);
                            p.playSound(b.getLocation(), Sound.BLOCK_AZALEA_BREAK, 0.4f, 0.25f);
                            this.xp(p, 2.0);
                        }
                        is.setAmount(is.getAmount() - 1);
                        hand.setAmount(is.getAmount());
                    }
                    this.totalMap.remove(p);
                    if (hand.getAmount() > 0) {
                        this.runPlayerViewport(this.getBlockFace(p), p.getTargetBlock(null, 5), p.getInventory().getItemInMainHand().getType(), p);
                    }
                    e.setCancelled(true);
                } else {
                    Adapt.messagePlayer(p, C.RED + Localizer.dLocalize("architect", "placement", "lore1") + " " + C.GREEN + this.totalMap.get(p).size() + C.RED + " " + Localizer.dLocalize("architect", "placement", "lore2"));
                }
            }
        }
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasAdaptation(p) && p.isSneaking()) {
            this.totalMap.remove(p);
        }
        if (this.hasAdaptation(p) && !p.isSneaking() && p.getInventory().getItemInMainHand().getType().isBlock()) {
            Block block = p.getTargetBlock(null, 5);
            Material handMaterial = p.getInventory().getItemInMainHand().getType();
            if (handMaterial.isAir()) {
                return;
            }
            BlockFace viewPortBlock = this.getBlockFace(p);
            this.runPlayerViewport(viewPortBlock, block, handMaterial, p);
        }
    }

    @EventHandler
    public void on(PlayerMoveEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasAdaptation(p) && !p.isSneaking()) {
            this.totalMap.remove(p);
        }
        if (this.hasAdaptation(p) && p.isSneaking() && p.getInventory().getItemInMainHand().getType().isBlock()) {
            Block block = p.getTargetBlock(null, 5);
            Material handMaterial = p.getInventory().getItemInMainHand().getType();
            if (handMaterial.isAir()) {
                return;
            }
            BlockFace viewPortBlock = this.getBlockFace(p);
            this.runPlayerViewport(viewPortBlock, block, handMaterial, p);
        }
    }

    public void runPlayerViewport(BlockFace viewPortBlock, Block block, Material handMaterial, Player p) {
        block10: {
            block11: {
                block9: {
                    if (viewPortBlock == null || !viewPortBlock.getDirection().equals((Object)BlockFace.NORTH.getDirection()) && !viewPortBlock.getDirection().equals((Object)BlockFace.SOUTH.getDirection())) break block9;
                    for (int x = block.getX() - 1; x <= block.getX() + 1; ++x) {
                        for (int y = block.getY() - 1; y <= block.getY() + 1; ++y) {
                            if (handMaterial != block.getWorld().getBlockAt(x, y, block.getZ()).getType()) continue;
                            if (this.totalMap.get(p) == null) {
                                HashMap<Block, BlockFace> map = new HashMap<Block, BlockFace>();
                                map.put(block.getWorld().getBlockAt(x, y, block.getZ()), viewPortBlock);
                                this.totalMap.put(p, map);
                                continue;
                            }
                            if (this.totalMap.get(p).size() > ((Config)this.getConfig()).maxBlocks) continue;
                            this.totalMap.get(p).put(block.getWorld().getBlockAt(x, y, block.getZ()), viewPortBlock);
                        }
                    }
                    break block10;
                }
                if (viewPortBlock == null || !viewPortBlock.getDirection().equals((Object)BlockFace.EAST.getDirection()) && !viewPortBlock.getDirection().equals((Object)BlockFace.WEST.getDirection())) break block11;
                for (int z = block.getZ() - 1; z <= block.getZ() + 1; ++z) {
                    for (int y = block.getY() - 1; y <= block.getY() + 1; ++y) {
                        if (handMaterial != block.getWorld().getBlockAt(block.getX(), y, z).getType()) continue;
                        if (this.totalMap.get(p) == null) {
                            HashMap<Block, BlockFace> map = new HashMap<Block, BlockFace>();
                            map.put(block.getWorld().getBlockAt(block.getX(), y, z), viewPortBlock);
                            this.totalMap.put(p, map);
                            continue;
                        }
                        if (this.totalMap.get(p).size() > ((Config)this.getConfig()).maxBlocks) continue;
                        this.totalMap.get(p).put(block.getWorld().getBlockAt(block.getX(), y, z), viewPortBlock);
                    }
                }
                break block10;
            }
            if (viewPortBlock == null || !viewPortBlock.getDirection().equals((Object)BlockFace.UP.getDirection()) && !viewPortBlock.getDirection().equals((Object)BlockFace.DOWN.getDirection())) break block10;
            for (int z = block.getZ() - 1; z <= block.getZ() + 1; ++z) {
                for (int x = block.getX() - 1; x <= block.getX() + 1; ++x) {
                    if (handMaterial != block.getWorld().getBlockAt(x, block.getY(), z).getType()) continue;
                    if (this.totalMap.get(p) == null) {
                        HashMap<Block, BlockFace> map = new HashMap<Block, BlockFace>();
                        map.put(block.getWorld().getBlockAt(x, block.getY(), z), viewPortBlock);
                        this.totalMap.put(p, map);
                        continue;
                    }
                    if (this.totalMap.get(p).size() > ((Config)this.getConfig()).maxBlocks) continue;
                    this.totalMap.get(p).put(block.getWorld().getBlockAt(x, block.getY(), z), viewPortBlock);
                }
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    @Override
    public void onTick() {
        if (!this.totalMap.isEmpty()) {
            J.a(() -> {
                for (Player p : this.totalMap.keySet()) {
                    if (!this.hasAdaptation(p) || !p.isSneaking()) {
                        this.totalMap.clear();
                        return;
                    }
                    Map<Block, BlockFace> blockRender = this.totalMap.get(p);
                    for (Block b : blockRender.keySet()) {
                        BlockFace bf = blockRender.get(b);
                        Block transposedBlock = b.getRelative(bf);
                        if (!((Config)this.getConfig()).showParticles) continue;
                        this.vfxCuboidOutline(transposedBlock, Particle.REVERSE_PORTAL);
                    }
                }
            });
        }
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int maxBlocks = 20;
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 1;
        int initialCost = 4;
        double costFactor = 2.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

