/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class AxeChop
extends SimpleAdaptation<Config> {
    public AxeChop() {
        super("axe-chop");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "chop", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "chop", "name"));
        this.setIcon(Material.IRON_AXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(6911L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + level + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore1"));
        v.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(level)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore2"));
        v.addLore(C.RED + "- " + this.getDamagePerBlock(this.getLevelPercent(level)) + C.GRAY + " " + Localizer.dLocalize("axe", "chop", "lore3"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent e) {
        BlockData b;
        Player p = e.getPlayer();
        if (p.getCooldown(p.getInventory().getItemInMainHand().getType()) > 0) {
            return;
        }
        if (e.getClickedBlock() != null && e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && this.isAxe(p.getInventory().getItemInMainHand()) && this.hasAdaptation(p) && this.isLog(new ItemStack((b = e.getClickedBlock().getBlockData()).getMaterial()))) {
            e.setCancelled(true);
            p.getLocation().getWorld().playSound(p.getLocation(), Sound.ITEM_AXE_STRIP, 1.25f, 0.6f);
            for (int i = 0; i < this.getLevel(p); ++i) {
                if (!this.breakStuff(e.getClickedBlock(), this.getRange(this.getLevel(p)), p)) continue;
                this.getSkill().xp(p, 5.0);
                p.setCooldown(p.getInventory().getItemInMainHand().getType(), this.getCooldownTime(this.getLevelPercent(p)));
                this.damageHand(p, this.getDamagePerBlock(this.getLevelPercent(p)));
            }
        }
    }

    private int getRange(int level) {
        return level * ((Config)this.getConfig()).rangeLevelMultiplier;
    }

    private int getCooldownTime(double levelPercent) {
        return (int)(((Config)this.getConfig()).cooldownTicksBase + ((Config)this.getConfig()).cooldownTicksInverseLevelMultiplier * (1.0 - levelPercent));
    }

    private int getDamagePerBlock(double levelPercent) {
        return (int)(((Config)this.getConfig()).damagePerBlockBase + ((Config)this.getConfig()).damagePerBlockInverseLevelMultiplier * (1.0 - levelPercent));
    }

    private boolean breakStuff(Block b, int power, Player player) {
        Block bb;
        Block last = b;
        for (int i = b.getY(); i < power + b.getY() && this.isLog(new ItemStack((bb = b.getWorld().getBlockAt(b.getX(), i, b.getZ())).getType())); ++i) {
            last = bb;
        }
        if (!this.canBlockBreak(player, last.getLocation())) {
            Adapt.verbose("Player " + player.getName() + " doesn't have permission.");
            return false;
        }
        if (!this.isLog(new ItemStack(last.getType()))) {
            return false;
        }
        Block ll = last;
        b.getWorld().playSound(ll.getLocation(), Sound.ITEM_AXE_STRIP, 0.75f, 1.3f);
        player.breakBlock(ll);
        return true;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.35;
        int maxLevel = 5;
        int initialCost = 2;
        int rangeLevelMultiplier = 5;
        double cooldownTicksBase = 15.0;
        double cooldownTicksInverseLevelMultiplier = 16.0;
        double damagePerBlockBase = 1.0;
        double damagePerBlockInverseLevelMultiplier = 4.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

