/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Impulse;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class AxeGroundSmash
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public AxeGroundSmash() {
        super("axe-ground-smash");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "groundsmash", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "groundsmash", "name"));
        this.setIcon(Material.NETHERITE_AXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4333L);
    }

    @Override
    public void addStats(int level, Element v) {
        double f = this.getLevelPercent(level);
        v.addLore(C.RED + "+ " + Form.f(this.getFalloffDamage(f), 1) + " - " + Form.f(this.getDamage(f), 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore1"));
        v.addLore(C.RED + "+ " + Form.f(this.getRadius(f), 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore2"));
        v.addLore(C.RED + "+ " + Form.pc(this.getForce(f), 0) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore3"));
        v.addLore(C.YELLOW + "* " + Form.duration((double)this.getCooldownTime(this.getLevelPercent(level)) * 50.0, 1) + C.GRAY + " " + Localizer.dLocalize("axe", "groundsmash", "lore4"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity) && p.isSneaking()) {
            if (!this.isAxe(p.getInventory().getItemInMainHand())) {
                return;
            }
            double f = this.getLevelPercent(p);
            if (p.hasCooldown(p.getInventory().getItemInMainHand().getType())) {
                return;
            }
            p.setCooldown(p.getInventory().getItemInMainHand().getType(), this.getCooldownTime(f));
            new Impulse(this.getRadius(f)).damage(this.getDamage(f), this.getFalloffDamage(f)).force(this.getForce(f)).punch(e.getEntity().getLocation());
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, SoundCategory.HOSTILE, 0.6f, 0.4f);
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_ZOMBIE_ATTACK_IRON_DOOR, SoundCategory.HOSTILE, 0.5f, 0.1f);
            e.getEntity().getWorld().playSound(e.getEntity().getLocation(), Sound.ENTITY_TURTLE_EGG_CRACK, SoundCategory.HOSTILE, 1.0f, 0.4f);
        }
    }

    public int getCooldownTime(double factor) {
        return (int)((1.0 - factor) * ((Config)this.getConfig()).cooldownTicksInverseLevelMultiplier + ((Config)this.getConfig()).cooldownTicksBase);
    }

    public double getRadius(double factor) {
        return ((Config)this.getConfig()).radiusLevelFactorMultiplier * factor;
    }

    public double getDamage(double factor) {
        return ((Config)this.getConfig()).damageLevelFactorMultiplier * factor;
    }

    public double getForce(double factor) {
        return ((Config)this.getConfig()).forceFactorMultiplier * factor + ((Config)this.getConfig()).forceBase;
    }

    public double getFalloffDamage(double factor) {
        return ((Config)this.getConfig()).falloffFactor * factor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 8;
        double falloffFactor = 3.0;
        double radiusLevelFactorMultiplier = 8.0;
        double damageLevelFactorMultiplier = 8.0;
        double forceFactorMultiplier = 1.15;
        double forceBase = 0.27;
        double cooldownTicksBase = 80.0;
        double cooldownTicksInverseLevelMultiplier = 225.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

