/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class AxeLeafVeinminer
extends SimpleAdaptation<Config> {
    public AxeLeafVeinminer() {
        super("axe-leaf-veinminer");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "leafminer", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "leafminer", "name"));
        this.setIcon(Material.BIRCH_LEAVES);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(5849L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("axe", "leafminer", "lore1"));
        v.addLore(C.GREEN + (level + ((Config)this.getConfig()).baseRange) + C.GRAY + " " + Localizer.dLocalize("axe", "leafminer", "lore2"));
        v.addLore(C.ITALIC + Localizer.dLocalize("axe", "leafminer", "lore3"));
    }

    private int getRadius(int lvl) {
        return lvl + ((Config)this.getConfig()).baseRange;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasAdaptation(p)) {
            if (!p.isSneaking()) {
                return;
            }
            if (!this.isAxe(p.getInventory().getItemInMainHand())) {
                return;
            }
            if (this.isLeaves(new ItemStack(e.getBlock().getType()))) {
                Block block = e.getBlock();
                HashMap<Location, Block> blockMap = new HashMap<Location, Block>();
                blockMap.put(block.getLocation(), block);
                for (int i = 0; i < this.getRadius(this.getLevel(p)); ++i) {
                    for (int x = -i; x <= i; ++x) {
                        for (int y = -i; y <= i; ++y) {
                            for (int z = -i; z <= i; ++z) {
                                Block b = block.getRelative(x, y, z);
                                if (b.getType() != block.getType() || block.getLocation().distance(b.getLocation()) > (double)this.getRadius(this.getLevel(p))) continue;
                                if (!this.canBlockBreak(p, b.getLocation())) {
                                    Adapt.verbose("Player " + p.getName() + " doesn't have permission.");
                                    continue;
                                }
                                blockMap.put(b.getLocation(), b);
                            }
                        }
                    }
                }
                J.s(() -> {
                    for (Location l : blockMap.keySet()) {
                        Block b = e.getBlock().getWorld().getBlockAt(l);
                        this.xp(p, 3.0);
                        if (this.getPlayer(p).getData().getSkillLines() != null && this.getPlayer(p).getData().getSkillLines().get("axes").getAdaptations() != null && this.getPlayer(p).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory").getLevel() > 0) {
                            Collection items = e.getBlock().getDrops();
                            for (ItemStack i : items) {
                                p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.01f, 0.01f);
                                this.xp(p, 2.0);
                                HashMap extra = p.getInventory().addItem(new ItemStack[]{i});
                                if (extra.isEmpty()) continue;
                                p.getWorld().dropItem(p.getLocation(), (ItemStack)extra.get(0));
                            }
                            p.breakBlock(l.getBlock());
                        } else {
                            b.breakNaturally(p.getItemInUse());
                            e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_FUNGUS_BREAK, 0.01f, 0.25f);
                            if (((Config)this.getConfig()).showParticles) {
                                e.getBlock().getWorld().spawnParticle(Particle.ASH, e.getBlock().getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1);
                            }
                        }
                        if (!((Config)this.getConfig()).showParticles) continue;
                        this.vfxCuboidOutline(b, Particle.ENCHANTMENT_TABLE);
                    }
                });
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 1;
        double costFactor = 0.325;
        int baseRange = 5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

