/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.axe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class AxeWoodVeinminer
extends SimpleAdaptation<Config> {
    public AxeWoodVeinminer() {
        super("axe-wood-veinminer");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("axe", "woodminer", "description"));
        this.setDisplayName(Localizer.dLocalize("axe", "woodminer", "name"));
        this.setIcon(Material.DIAMOND_AXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(5849L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("axe", "woodminer", "lore1"));
        v.addLore(C.GREEN + (level + ((Config)this.getConfig()).baseRange) + C.GRAY + " " + Localizer.dLocalize("axe", "woodminer", "lore2"));
        v.addLore(C.ITALIC + Localizer.dLocalize("axe", "woodminer", "lore3"));
    }

    private int getRadius(int lvl) {
        return lvl + ((Config)this.getConfig()).baseRange;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (this.hasAdaptation(p)) {
            if (!p.isSneaking()) {
                return;
            }
            if (!this.isAxe(p.getInventory().getItemInMainHand())) {
                return;
            }
            if (this.isLog(new ItemStack(e.getBlock().getType()))) {
                Block block = e.getBlock();
                HashSet<Block> blockMap = new HashSet<Block>();
                int blockCount = 0;
                for (int i = 0; i < this.getRadius(this.getLevel(p)); ++i) {
                    for (int x = -i; x <= i; ++x) {
                        for (int y = -i; y <= i; ++y) {
                            for (int z = -i; z <= i; ++z) {
                                Block b = block.getRelative(x, y, z);
                                if (b.getType() != block.getType()) continue;
                                if (++blockCount > ((Config)this.getConfig()).maxBlocks) {
                                    Adapt.verbose("Block: " + blockCount + " > " + ((Config)this.getConfig()).maxBlocks);
                                    continue;
                                }
                                if (block.getLocation().distance(b.getLocation()) > (double)this.getRadius(this.getLevel(p))) {
                                    Adapt.verbose("Block: " + b.getLocation() + " is too far away from " + block.getLocation() + " (" + this.getRadius(this.getLevel(p)) + ")");
                                    continue;
                                }
                                if (!this.canBlockBreak(p, b.getLocation())) {
                                    Adapt.verbose("Player " + p.getName() + " doesn't have permission.");
                                    continue;
                                }
                                blockMap.add(b);
                            }
                        }
                    }
                }
                J.s(() -> {
                    for (Block blocks : blockMap) {
                        if (this.getPlayer(p).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("axes").getAdaptations().get("axe-drop-to-inventory").getLevel() > 0) {
                            Collection items = blocks.getDrops();
                            for (ItemStack item : items) {
                                this.safeGiveItem(p, item);
                                Adapt.verbose("Giving item: " + item);
                            }
                            blocks.setType(Material.AIR);
                        } else {
                            blocks.breakNaturally(p.getItemInUse());
                            blocks.getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_FUNGUS_BREAK, 0.01f, 0.25f);
                            if (((Config)this.getConfig()).showParticles) {
                                blocks.getWorld().spawnParticle(Particle.ASH, blocks.getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1);
                            }
                        }
                        if (!((Config)this.getConfig()).showParticles) continue;
                        this.vfxCuboidOutline(blocks, Particle.ENCHANTMENT_TABLE);
                    }
                });
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 3;
        int maxLevel = 5;
        int initialCost = 4;
        double costFactor = 2.325;
        int maxBlocks = 20;
        int baseRange = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

