/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.blocking;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.content.item.multiItems.MultiArmor;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockingMultiArmor
extends SimpleAdaptation<Config> {
    private static final MultiArmor multiarmor;
    private final Map<Player, Long> cooldowns;

    public BlockingMultiArmor() {
        super("blocking-multiarmor");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("blocking", "multiarmor", "name"));
        this.setDescription(Localizer.dLocalize("blocking", "multiarmor", "description"));
        this.setIcon(Material.ELYTRA);
        this.setInterval(20202L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore1"));
        v.addLore(C.GRAY + level + C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore2"));
        v.addLore(C.GREEN + Localizer.dLocalize("blocking", "multiarmor", "lore3"));
        v.addLore(C.RED + Localizer.dLocalize("blocking", "multiarmor", "lore4"));
        v.addLore(C.GRAY + Localizer.dLocalize("blocking", "multiarmor", "lore5"));
        v.addLore(C.UNDERLINE + Localizer.dLocalize("blocking", "multiarmor", "lore6"));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerMoveEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack chest = p.getInventory().getChestplate();
        if (chest != null && this.hasAdaptation(p) && this.validateArmor(chest)) {
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p) + 3000L > System.currentTimeMillis()) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            if (p.isOnGround() && !p.isFlying()) {
                if (this.isChestplate(chest)) {
                    return;
                }
                J.s(() -> p.getInventory().setChestplate(multiarmor.nextChestplate(chest)));
                this.cooldowns.put(p, System.currentTimeMillis());
                p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                p.getWorld().playSound(p.getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 0.5f, 0.77f);
            } else if (p.getFallDistance() > 4.0f) {
                if (this.isElytra(chest)) {
                    return;
                }
                J.s(() -> p.getInventory().setChestplate(multiarmor.nextElytra(chest)));
                this.cooldowns.put(p, System.currentTimeMillis());
                p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                p.getWorld().playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.5f, 0.77f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (p.isSneaking() && this.validateArmor(e.getItemDrop().getItemStack())) {
            List<ItemStack> drops = multiarmor.explode(e.getItemDrop().getItemStack());
            for (ItemStack i : drops) {
                Damageable iDmgable = (Damageable)i.getItemMeta();
                if (i.hasItemMeta()) {
                    ItemMeta im;
                    ItemMeta im2 = im = i.getItemMeta().clone();
                    if (im.hasDisplayName()) {
                        im2.setDisplayName(im.getDisplayName());
                    }
                    if (im.hasEnchants()) {
                        Map enchants = im.getEnchants();
                        for (Enchantment enchant : enchants.keySet()) {
                            im2.addEnchant(enchant, ((Integer)enchants.get(enchant)).intValue(), true);
                        }
                    }
                    if (iDmgable != null && iDmgable.hasDamage()) {
                        ((Damageable)im2).setDamage(iDmgable.getDamage());
                    }
                    im2.setLore(null);
                    i.setItemMeta(im2);
                }
                drops.set(drops.indexOf(i), i);
            }
            J.s(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_DEATH, 0.25f, 0.77f);
                for (ItemStack i : drops) {
                    p.getWorld().dropItem(p.getLocation(), i);
                }
            });
            e.getItemDrop().setItemStack(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        if (!this.hasAdaptation((Player)e.getWhoClicked())) {
            return;
        }
        if (e.getClickedInventory() != null && e.getClick().equals((Object)ClickType.SHIFT_LEFT) && e.getClickedInventory().getItem(e.getSlot()) != null && e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            ItemStack cursor = e.getWhoClicked().getItemOnCursor().clone();
            ItemStack clicked = e.getClickedInventory().getItem(e.getSlot()).clone();
            if (cursor.getType().equals((Object)Material.ELYTRA) || clicked.getType().equals((Object)Material.ELYTRA)) {
                if ((multiarmor.explode(cursor).size() > 1 || multiarmor.explode(clicked).size() > 1) && ((double)multiarmor.explode(cursor).size() >= this.getSlots(this.getLevel((Player)e.getWhoClicked())) || (double)multiarmor.explode(clicked).size() >= this.getSlots(this.getLevel((Player)e.getWhoClicked())))) {
                    e.setCancelled(true);
                    ((Player)e.getWhoClicked()).playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 0.77f);
                    return;
                }
                if (ItemListings.getMultiArmorable().contains(cursor.getType()) && ItemListings.getMultiArmorable().contains(clicked.getType()) && !cursor.getType().isAir() && !clicked.getType().isAir() && multiarmor.supportsItem(cursor) && multiarmor.supportsItem(clicked)) {
                    e.setCancelled(true);
                    e.getWhoClicked().setItemOnCursor(new ItemStack(Material.AIR));
                    e.getClickedInventory().setItem(e.getSlot(), multiarmor.build(cursor, clicked));
                    e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                }
            }
        }
    }

    private boolean validateArmor(ItemStack item) {
        if (item.getItemMeta() != null && item.getItemMeta().getLore() != null && item.getItemMeta().getLore().get(0) != null) {
            return ((String)item.getItemMeta().getLore().get(0)).contains("MultiArmor");
        }
        return false;
    }

    private double getSlots(double level) {
        return (double)((Config)this.getConfig()).startingSlots + level;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        multiarmor = new MultiArmor();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int initialCost = 3;
        double costFactor = 1.0;
        int maxLevel = 1;
        int startingSlots = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

