/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.brewing;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.data.WorldData;
import com.volmit.adapt.api.world.PlayerAdaptation;
import com.volmit.adapt.api.world.PlayerData;
import com.volmit.adapt.content.matter.BrewingStandOwner;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BrewingStand;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class BrewingLingering
extends SimpleAdaptation<Config> {
    public BrewingLingering() {
        super("brewing-lingering");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("brewing", "lingering", "description"));
        this.setDisplayName(Localizer.dLocalize("brewing", "lingering", "name"));
        this.setIcon(Material.CLOCK);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(4788L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.duration((long)this.getDurationBoost(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "lingering", "lore1"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getPercentBoost(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("brewing", "lingering", "lore2"));
    }

    public double getDurationBoost(double factor) {
        return ((Config)this.getConfig()).durationBoostFactorTicks * factor + ((Config)this.getConfig()).baseDurationBoostTicks;
    }

    public double getPercentBoost(double factor) {
        return 1.0 + (factor * factor * ((Config)this.getConfig()).durationMultiplierFactor + ((Config)this.getConfig()).baseDurationMultiplier);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BrewEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (e.getBlock().getType().equals((Object)Material.BREWING_STAND)) {
            BrewingStandOwner owner = WorldData.of(e.getBlock().getWorld()).getMantle().get(e.getBlock().getX(), e.getBlock().getY(), e.getBlock().getZ(), BrewingStandOwner.class);
            if (owner != null) {
                J.s(() -> {
                    PlayerData data = null;
                    ItemStack[] c = ((BrewingStand)e.getBlock().getState()).getInventory().getStorageContents();
                    boolean ef = false;
                    for (int i = 0; i < c.length; ++i) {
                        PlayerAdaptation a;
                        ItemMeta patt3890$temp;
                        ItemStack is = c[i];
                        if (is == null || is.getItemMeta() == null || !((patt3890$temp = is.getItemMeta()) instanceof PotionMeta)) continue;
                        PotionMeta p = (PotionMeta)patt3890$temp;
                        is = is.clone();
                        PlayerData playerData = data = data == null ? this.getServer().peekData(owner.getOwner()) : data;
                        if (!data.getSkillLines().containsKey(this.getSkill().getName()) || !data.getSkillLine(this.getSkill().getName()).getAdaptations().containsKey(this.getName()) || (a = data.getSkillLine(this.getSkill().getName()).getAdaptations().get(this.getName())).getLevel() <= 0) continue;
                        double factor = this.getLevelPercent(a.getLevel());
                        ef = this.enhance(factor, is, p) || ef;
                        c[i] = is;
                    }
                    if (ef) {
                        ((BrewingStand)e.getBlock().getState()).getInventory().setStorageContents(c);
                        e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 0.75f);
                        e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.75f);
                    }
                });
            } else {
                Adapt.verbose("No Owner");
            }
        }
    }

    private boolean enhance(double factor, ItemStack is, PotionMeta p) {
        PotionEffect effect;
        if (!p.getBasePotionData().getType().isInstant() && (effect = this.getRawPotionEffect(is)) != null) {
            p.addCustomEffect(new PotionEffect(effect.getType(), (int)(this.getDurationBoost(factor) + (double)effect.getDuration() * this.getPercentBoost(factor)), effect.getAmplifier()), true);
            is.setItemMeta((ItemMeta)p);
            return true;
        }
        return false;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        double costFactor = 0.75;
        int maxLevel = 5;
        int initialCost = 5;
        double baseDurationBoostTicks = 100.0;
        double durationBoostFactorTicks = 500.0;
        double durationMultiplierFactor = 0.45;
        double baseDurationMultiplier = 0.05;

        static {
            IBootstrap.dasBoot();
        }
    }
}

