/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingInventory;

public class CraftingDeconstruction
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public CraftingDeconstruction() {
        super("crafting-deconstruction");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "deconstruction", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "deconstruction", "name"));
        this.setIcon(Material.SHEARS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(1);
        this.setInterval(5590L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore1"));
        v.addLore(C.GREEN + Localizer.dLocalize("crafting", "deconstruction", "lore2"));
    }

    public ItemStack getDeconstructionOffering(ItemStack forStuff) {
        ShapedRecipe r;
        if (forStuff == null) {
            return null;
        }
        int maxPow = 0;
        Recipe sr = null;
        for (Recipe i : Bukkit.getRecipesFor((ItemStack)forStuff)) {
            int mp;
            if (i instanceof ShapelessRecipe) {
                ShapelessRecipe r2 = (ShapelessRecipe)i;
                mp = r2.getIngredientList().stream().mapToInt(f -> f.getAmount()).sum();
                if (mp <= maxPow) continue;
                sr = i;
                maxPow = mp;
                continue;
            }
            if (!(i instanceof ShapedRecipe) || (mp = (r = (ShapedRecipe)i).getIngredientMap().values().stream().mapToInt(f -> f == null ? 0 : f.getAmount()).sum()) <= maxPow) continue;
            sr = i;
            maxPow = mp;
        }
        if (sr == null) {
            return null;
        }
        int v = 0;
        int outa = 1;
        ItemStack sel = null;
        if (sr instanceof ShapelessRecipe) {
            r = (ShapelessRecipe)sr;
            for (ItemStack i : r.getIngredientList()) {
                if (i.getAmount() * forStuff.getAmount() <= v) continue;
                v = i.getAmount() * forStuff.getAmount();
                sel = i;
                outa = r.getResult().getAmount();
            }
        } else {
            ShapedRecipe r3 = (ShapedRecipe)sr;
            ArrayList ings = new ArrayList();
            r3.getIngredientMap().forEach((k, vx) -> {
                if (vx == null) {
                    return;
                }
                for (ItemStack i : ings) {
                    if (!vx.getType().equals((Object)i.getType())) continue;
                    i.setAmount(i.getAmount() + 1);
                    return;
                }
                ings.add(vx);
            });
            for (ItemStack i : ings) {
                if (i == null || i.getAmount() * forStuff.getAmount() <= v) continue;
                v = i.getAmount() * forStuff.getAmount();
                sel = i;
                outa = r3.getResult().getAmount();
            }
        }
        if (sel != null && sel.getAmount() * forStuff.getAmount() > 1) {
            int a = (sel = sel.clone()).getAmount() * forStuff.getAmount() / outa / 2;
            if (a > sel.getMaxStackSize()) {
                return null;
            }
            sel.setAmount(a);
            if (this.getValue(sel) >= this.getValue(forStuff)) {
                return null;
            }
            return sel;
        }
        return null;
    }

    public int getShearDamage(ItemStack forStuff) {
        return forStuff.getAmount() * 8;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        SmithingInventory s;
        if (e.getClickedInventory() == null || e.isCancelled()) {
            return;
        }
        if (!this.hasAdaptation((Player)e.getWhoClicked())) {
            return;
        }
        if (e.getView().getTopInventory().getType().equals((Object)InventoryType.SMITHING)) {
            s = (SmithingInventory)e.getView().getTopInventory();
            J.s(() -> {
                if (s.getItem(1) != null && s.getItem(1).getType().equals((Object)Material.SHEARS) && s.getItem(0) != null) {
                    s.setResult(this.getDeconstructionOffering(s.getItem(0)));
                }
            });
        }
        if (e.getClickedInventory() != null && e.getClickedInventory().getType().equals((Object)InventoryType.SMITHING)) {
            ItemStack offering;
            s = (SmithingInventory)e.getClickedInventory();
            if (e.getSlotType().equals((Object)InventoryType.SlotType.CRAFTING)) {
                J.s(() -> {
                    if (s.getItem(1) != null && s.getItem(1).getType().equals((Object)Material.SHEARS) && s.getItem(0) != null) {
                        s.setResult(this.getDeconstructionOffering(s.getItem(0)));
                    }
                });
            } else if (e.getSlotType().equals((Object)InventoryType.SlotType.RESULT) && s.getItem(1) != null && s.getItem(1).getType().equals((Object)Material.SHEARS) && s.getItem(0) != null && (offering = this.getDeconstructionOffering(s.getItem(0))) != null) {
                s.setItem(1, this.damage(s.getItem(1), s.getItem(0).getAmount()));
                e.setCursor(offering);
                e.getClickedInventory().setItem(0, null);
                e.getWhoClicked().getWorld().playSound(e.getClickedInventory().getLocation(), Sound.BLOCK_BASALT_BREAK, 1.0f, 0.2f);
                e.getWhoClicked().getWorld().playSound(e.getClickedInventory().getLocation(), Sound.BLOCK_BEEHIVE_SHEAR, 1.0f, 0.7f);
                this.getSkill().xp((Player)e.getWhoClicked(), this.getValue(offering));
            }
        }
    }

    private void updateOffering(Inventory inventory) {
        SmithingInventory s = (SmithingInventory)inventory;
        if (s.getItem(1) != null && s.getItem(1).getType().equals((Object)Material.SHEARS) && s.getItem(0) != null) {
            ItemStack offering = this.getDeconstructionOffering(s.getItem(0));
            s.setResult(offering);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 9;
        int initialCost = 8;
        double costFactor = 1.355;

        static {
            IBootstrap.dasBoot();
        }
    }
}

