/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftingStations
extends SimpleAdaptation<Config> {
    public CraftingStations() {
        super("crafting-stations");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("crafting", "stations", "description"));
        this.setDisplayName(Localizer.dLocalize("crafting", "stations", "name"));
        this.setIcon(Material.CRAFTING_TABLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(9248L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.RED + Localizer.dLocalize("crafting", "stations", "lore2"));
        v.addLore(C.GRAY + Localizer.dLocalize("crafting", "stations", "lore3"));
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        ItemStack hand = p.getInventory().getItemInMainHand();
        switch (hand.getType()) {
            case CRAFTING_TABLE: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                p.openWorkbench(null, true);
                break;
            }
            case GRINDSTONE: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.GRINDSTONE);
                p.openInventory(inv);
                break;
            }
            case ANVIL: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.ANVIL);
                p.openInventory(inv);
                break;
            }
            case STONECUTTER: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.STONECUTTER);
                p.openInventory(inv);
                break;
            }
            case CARTOGRAPHY_TABLE: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.CARTOGRAPHY);
                p.openInventory(inv);
                break;
            }
            case LOOM: {
                if (p.hasCooldown(hand.getType())) {
                    e.setCancelled(true);
                    return;
                }
                NMS.get().sendCooldown(p, hand.getType(), 1000);
                p.setCooldown(hand.getType(), 1000);
                if (!e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) break;
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                Inventory inv = Bukkit.createInventory((InventoryHolder)p, (InventoryType)InventoryType.LOOM);
                p.openInventory(inv);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public int cooldown = 125;
        boolean permanent = true;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 1;
        int initialCost = 2;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

