/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.crafting;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class CraftingXP
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldown = new HashMap<Player, Long>();

    public CraftingXP() {
        super("crafting-xp");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("crafting", "xp", "name"));
        this.setDescription(Localizer.dLocalize("crafting", "xp", "description"));
        this.setIcon(Material.EXPERIENCE_BOTTLE);
        this.setInterval(5580L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("crafting", "xp", "lore1"));
    }

    @EventHandler
    public void on(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        this.cooldown.remove(p);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(CraftItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getInventory().getResult() != null && !e.isCancelled() && this.hasAdaptation(p) && e.getInventory().getResult().getAmount() > 0 && e.getInventory().getResult() != null && e.getCursor() != null && e.getCursor().getAmount() < 64 && p.getInventory().addItem(new ItemStack[]{e.getCurrentItem()}).isEmpty()) {
            p.getInventory().removeItem(new ItemStack[]{e.getCurrentItem()});
            if (this.cooldown.containsKey(p) && this.cooldown.get(p) + 20000L < System.currentTimeMillis()) {
                this.cooldown.remove(p);
            } else if (this.cooldown.containsKey(p) && this.cooldown.get(p) + 20000L > System.currentTimeMillis()) {
                return;
            }
            this.cooldown.put(p, System.currentTimeMillis());
            ((ExperienceOrb)p.getWorld().spawn(p.getLocation(), ExperienceOrb.class)).setExperience(this.getLevel(p) * 2);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 7;

        static {
            IBootstrap.dasBoot();
        }
    }
}

