/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.world.AdaptPlayer;
import com.volmit.adapt.api.world.PlayerSkillLine;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.Map.XMap;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerExpChangeEvent;
import xyz.xenondevs.particle.utils.MathUtils;

public class DiscoveryUnity
extends SimpleAdaptation<Config> {
    public DiscoveryUnity() {
        super("discovery-unity");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "unity", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "unity", "name"));
        this.setIcon(Material.REDSTONE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(666L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.f(this.getXPGained(this.getLevelPercent(level), 1), 0) + " " + Localizer.dLocalize("discovery", "unity", "lore1") + C.GRAY + " " + Localizer.dLocalize("discovery", "unity", "lore2"));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void on(PlayerExpChangeEvent e) {
        Player p = e.getPlayer();
        AdaptPlayer ap = this.getPlayer(p);
        if (this.hasAdaptation(p) && e.getAmount() > 0) {
            this.xp(p, 5.0);
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.9f);
            List<PlayerSkillLine> skills = XMap.sortV(ap.getData().getSkillLines());
            if (skills.size() > 0) {
                PlayerSkillLine skill = skills.get(MathUtils.RANDOM.nextInt(skills.size()));
                skill.giveXPFresh(Adapt.instance.getAdaptServer().getPlayer(p).getNot(), this.getXPGained(this.getLevelPercent(this.getLevel(p)), MathUtils.RANDOM.nextInt(3) + 1));
            }
        }
    }

    private double getXPGained(double factor, int amount) {
        return (double)amount * ((Config)this.getConfig()).xpGainedMultiplier * factor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 7;
        double xpGainedMultiplier = 8.0;
        double xpBoostMultiplier = 0.01;
        int xpBoostDuration = 15000;

        static {
            IBootstrap.dasBoot();
        }
    }
}

