/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.discovery;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DiscoveryVillagerAtt
extends SimpleAdaptation<Config> {
    public DiscoveryVillagerAtt() {
        super("discovery-villager-att");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("discovery", "villager", "description"));
        this.setDisplayName(Localizer.dLocalize("discovery", "villager", "name"));
        this.setIcon(Material.GLASS_BOTTLE);
        this.setInterval(5832L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("discovery", "villager", "lore1"));
        v.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("discovery", "villager", "lore2"));
        v.addLore(C.GREEN + "+ " + this.getXpTaken(level) + " " + C.GRAY + Localizer.dLocalize("discovery", "villager", "lore3"));
    }

    private double getEffectiveness(double multiplier) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, multiplier * multiplier + ((Config)this.getConfig()).effectivenessBase);
    }

    private int getXpTaken(double level) {
        double d = (double)((Config)this.getConfig()).levelCostAdd * ((Config)this.getConfig()).amplifier - level * (double)((Config)this.getConfig()).levelDrain;
        return (int)d;
    }

    @EventHandler
    public void on(PlayerInteractEntityEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        Entity entity = e.getRightClicked();
        if (entity instanceof Villager) {
            Random r;
            Villager v = (Villager)entity;
            if (this.hasAdaptation(p) && (r = new Random()).nextDouble() <= this.getEffectiveness(this.getLevelPercent(this.getLevel(p)))) {
                if (p.getLevel() - this.getXpTaken(this.getLevel(p)) > 0) {
                    BleedEffect blood = new BleedEffect(Adapt.instance.adaptEffectManager);
                    blood.material = Material.EMERALD;
                    blood.setEntity((Entity)v);
                    p.setLevel(p.getLevel() - this.getXpTaken(this.getLevel(p)));
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_CELEBRATE, 1.0f, 1.0f);
                    p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    p.addPotionEffect(new PotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE, 10, this.getLevel(p), true, true));
                } else {
                    BleedEffect blood = new BleedEffect(Adapt.instance.adaptEffectManager);
                    blood.material = Material.STONE;
                    v.shakeHead();
                    blood.setEntity((Entity)v);
                    p.playSound(p.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int initialCost = 5;
        double costFactor = 0.01;
        int maxLevel = 5;
        double effectivenessBase = 0.005;
        double maxEffectiveness = 100.0;
        int levelDrain = 2;
        int levelCostAdd = 10;
        double amplifier = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

