/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ExcavationHaste
extends SimpleAdaptation<Config> {
    public ExcavationHaste() {
        super("excavation-haste");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("excavation", "haste", "name"));
        this.setDescription(Localizer.dLocalize("excavation", "haste", "description"));
        this.setIcon(Material.GOLDEN_PICKAXE);
        this.setInterval(4388L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("excavation", "haste", "lore1"));
        v.addLore(C.GREEN + level + C.GRAY + Localizer.dLocalize("excavation", "haste", "lore2"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, 15, this.getLevel(p), false, false, true));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 3;
        double costFactor = 0.3;
        int maxLevel = 3;

        static {
            IBootstrap.dasBoot();
        }
    }
}

