/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.excavation;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.content.item.multiItems.OmniTool;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ExcavationOmniTool
extends SimpleAdaptation<Config> {
    private static final OmniTool omniTool;

    public ExcavationOmniTool() {
        super("excavation-omnitool");
        this.registerConfiguration(Config.class);
        this.setDisplayName(Localizer.dLocalize("excavation", "omnitool", "name"));
        this.setDescription(Localizer.dLocalize("excavation", "omnitool", "description"));
        this.setIcon(Material.DISC_FRAGMENT_5);
        this.setInterval(20202L);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore1"));
        v.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore2"));
        v.addLore(C.GREEN + Localizer.dLocalize("excavation", "omnitool", "lore3"));
        v.addLore(C.RED + Localizer.dLocalize("excavation", "omnitool", "lore4"));
        v.addLore(C.GRAY + Localizer.dLocalize("excavation", "omnitool", "lore5"));
        v.addLore(C.GREEN + (level + ((Config)this.getConfig()).startingSlots) + C.GRAY + " " + Localizer.dLocalize("excavation", "omnitool", "lore6"));
        v.addLore(C.UNDERLINE + Localizer.dLocalize("excavation", "omnitool", "lore7"));
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.validateTool((p = (Player)entity).getInventory().getItemInMainHand())) {
            if (p.getInventory().getItemInMainHand().getType().getMaxDurability() - p.getInventory().getItemInMainHand().getDurability() <= 2) {
                e.setCancelled(true);
                return;
            }
            if (e.isCancelled()) {
                return;
            }
            if (!this.hasAdaptation(p) && this.validateTool(p.getInventory().getItemInMainHand())) {
                e.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(p)) {
                if (this.validateTool(p.getInventory().getItemInMainHand())) {
                    e.setCancelled(true);
                }
                return;
            }
            ItemStack hand = p.getInventory().getItemInMainHand();
            Damageable inHand = (Damageable)hand.getItemMeta();
            if (!this.validateTool(hand)) {
                return;
            }
            J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextSword(hand)));
            p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
            if (inHand != null && inHand.hasDamage() && hand.getType().getMaxDurability() - inHand.getDamage() - 2 <= 2) {
                e.setCancelled(true);
                p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        if (this.validateTool(p.getInventory().getItemInMainHand())) {
            if (p.getInventory().getItemInMainHand().getType().getMaxDurability() - p.getInventory().getItemInMainHand().getDurability() <= 2) {
                e.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(p)) {
                e.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (this.validateTool(p.getInventory().getItemInMainHand())) {
            if (p.getInventory().getItemInMainHand().getType().getMaxDurability() - p.getInventory().getItemInMainHand().getDurability() <= 2) {
                e.setCancelled(true);
                return;
            }
            if (!this.hasAdaptation(p)) {
                return;
            }
            if (e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
                ItemStack hand = p.getInventory().getItemInMainHand();
                Damageable imHand = (Damageable)hand.getItemMeta();
                Block block = e.getClickedBlock();
                if (block != null) {
                    if (ItemListings.farmable.contains(block.getType())) {
                        if (this.isShovel(hand)) {
                            J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextHoe(hand)));
                            p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        } else {
                            J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextShovel(hand)));
                            p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        }
                        if (imHand != null && imHand.hasDamage() && hand.getType().getMaxDurability() - imHand.getDamage() - 2 <= 2) {
                            e.setCancelled(true);
                            p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
                        }
                    } else if (ItemListings.burnable.contains(block.getType())) {
                        J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextFnS(hand)));
                        p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
                        if (imHand != null && imHand.hasDamage() && hand.getType().getMaxDurability() - imHand.getDamage() - 2 <= 2) {
                            e.setCancelled(true);
                            p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerDropItemEvent e) {
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (p.isSneaking() && this.validateTool(e.getItemDrop().getItemStack())) {
            List<ItemStack> drops = omniTool.explode(e.getItemDrop().getItemStack());
            for (ItemStack i : drops) {
                Damageable iDmgable = (Damageable)i.getItemMeta();
                if (i.hasItemMeta()) {
                    ItemMeta im;
                    ItemMeta im2 = im = i.getItemMeta().clone();
                    if (im.hasDisplayName()) {
                        im2.setDisplayName(im.getDisplayName());
                    }
                    if (im.hasEnchants()) {
                        Map enchants = im.getEnchants();
                        for (Enchantment enchant : enchants.keySet()) {
                            im2.addEnchant(enchant, ((Integer)enchants.get(enchant)).intValue(), true);
                        }
                    }
                    if (iDmgable != null && iDmgable.hasDamage()) {
                        ((Damageable)im2).setDamage(iDmgable.getDamage());
                    }
                    im2.setLore(null);
                    i.setItemMeta(im2);
                }
                drops.set(drops.indexOf(i), i);
            }
            J.s(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_DEATH, 0.25f, 0.77f);
                for (ItemStack i : drops) {
                    p.getWorld().dropItem(p.getLocation(), i);
                }
            });
            e.getItemDrop().setItemStack(new ItemStack(Material.AIR));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void on(BlockDamageEvent e) {
        Player p = e.getPlayer();
        Block b = e.getBlock();
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (this.validateTool(hand)) {
            if (e.isCancelled()) {
                return;
            }
            if (!this.hasAdaptation(p)) {
                return;
            }
            Damageable imHand = (Damageable)hand.getItemMeta();
            if (ItemListings.getAxePreference().contains(b.getType())) {
                if (!this.isAxe(hand)) {
                    Adapt.verbose("Omnitool for " + p.getName() + " changed to axe");
                    J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextAxe(hand)));
                    this.itemDelegate(e, hand, imHand);
                } else {
                    Adapt.verbose("Omnitool for " + p.getName() + " is already axe");
                }
            } else if (ItemListings.getShovelPreference().contains(b.getType())) {
                if (!this.isShovel(hand)) {
                    Adapt.verbose("Omnitool for " + p.getName() + " changed to shovel");
                    J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextShovel(hand)));
                    this.itemDelegate(e, hand, imHand);
                } else {
                    Adapt.verbose("Omnitool for " + p.getName() + " is already shovel");
                }
            } else if (ItemListings.getSwordPreference().contains(b.getType())) {
                if (!this.isSword(hand)) {
                    Adapt.verbose("Omnitool for " + p.getName() + " changed to sword");
                    J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextSword(hand)));
                    this.itemDelegate(e, hand, imHand);
                } else {
                    Adapt.verbose("Omnitool for " + p.getName() + " is already sword");
                }
            } else if (!this.isPickaxe(hand)) {
                Adapt.verbose("Omnitool for " + p.getName() + " changed to pickaxe");
                J.s(() -> p.getInventory().setItemInMainHand(omniTool.nextPickaxe(hand)));
                this.itemDelegate(e, hand, imHand);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(InventoryClickEvent e) {
        if (!this.hasAdaptation((Player)e.getWhoClicked())) {
            return;
        }
        if (e.getClickedInventory() != null && e.getClick().equals((Object)ClickType.SHIFT_LEFT) && e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
            ItemStack cursor = e.getWhoClicked().getItemOnCursor().clone();
            ItemStack clicked = e.getClickedInventory().getItem(e.getSlot()).clone();
            if ((omniTool.explode(cursor).size() > 1 || omniTool.explode(clicked).size() > 1) && ((double)omniTool.explode(cursor).size() >= this.getSlots(this.getLevel((Player)e.getWhoClicked())) || (double)omniTool.explode(clicked).size() >= this.getSlots(this.getLevel((Player)e.getWhoClicked())))) {
                e.setCancelled(true);
                ((Player)e.getWhoClicked()).playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 0.77f);
                return;
            }
            if (ItemListings.tool.contains(cursor.getType()) && ItemListings.tool.contains(clicked.getType()) && !cursor.getType().isAir() && !clicked.getType().isAir() && omniTool.supportsItem(cursor) && omniTool.supportsItem(clicked)) {
                e.setCancelled(true);
                e.getWhoClicked().setItemOnCursor(new ItemStack(Material.AIR));
                e.getClickedInventory().setItem(e.getSlot(), omniTool.build(cursor, clicked));
                e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
            }
        }
    }

    private void itemDelegate(BlockDamageEvent e, ItemStack hand, Damageable imHand) {
        Player p = e.getPlayer();
        p.getWorld().playSound(p.getLocation(), Sound.ITEM_ARMOR_EQUIP_ELYTRA, 1.0f, 0.77f);
        if (imHand != null && imHand.hasDamage() && hand.getType().getMaxDurability() - imHand.getDamage() - 2 <= 2) {
            e.setCancelled(true);
            p.playSound(p.getLocation(), Sound.ENTITY_IRON_GOLEM_STEP, 0.25f, 0.77f);
        }
    }

    private boolean validateTool(ItemStack item) {
        return item.getItemMeta() != null && item.getItemMeta().getLore() != null && item.getItemMeta().getLore().toString().contains("Leatherman");
    }

    private double getSlots(double level) {
        return (double)((Config)this.getConfig()).startingSlots + level;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
        omniTool = new OmniTool();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 10;
        int initialCost = 3;
        double costFactor = 0.2;
        int maxLevel = 5;
        int startingSlots = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

