/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageEvent;

public class HerbalismHungryShield
extends SimpleAdaptation<Config> {
    public HerbalismHungryShield() {
        super("herbalism-hungry-shield");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "hungryshield", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "hungryshield", "name"));
        this.setIcon(Material.APPLE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(875L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getEffectiveness(this.getLevelPercent(level)), 0) + C.GRAY + " " + Localizer.dLocalize("herbalism", "hungryshield", "lore1"));
    }

    @Override
    public void onTick() {
    }

    private double getEffectiveness(double factor) {
        return Math.min(((Config)this.getConfig()).maxEffectiveness, factor * factor + ((Config)this.getConfig()).effectivenessBase);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity)) {
            double f = this.getEffectiveness(this.getLevelPercent(p));
            double h = e.getDamage() * f;
            double d = e.getDamage() - h;
            if (this.getPlayer(p).consumeFood(h, 6)) {
                e.setDamage(d += h);
                this.xp(p, d);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 7;
        int maxLevel = 5;
        int initialCost = 14;
        double costFactor = 0.925;
        double effectivenessBase = 0.15;
        double maxEffectiveness = 0.95;

        static {
            IBootstrap.dasBoot();
        }
    }
}

