/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.ItemStack;

public class HerbalismLuck
extends SimpleAdaptation<Config> {
    public HerbalismLuck() {
        super("herbalism-luck");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "luck", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "luck", "name"));
        this.setIcon(Material.EMERALD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(8121L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + C.GRAY + Localizer.dLocalize("herbalism", "luck", "lore0"));
        v.addLore(C.GREEN + "+ (" + this.getEffectiveness(level) + C.GRAY + "%) + " + Localizer.dLocalize("herbalism", "luck", "lore1"));
        v.addLore(C.GREEN + "+ (" + this.getEffectiveness(level) + C.GRAY + "%) + " + Localizer.dLocalize("herbalism", "luck", "lore2"));
    }

    private double getEffectiveness(double factor) {
        return Math.min(((Config)this.getConfig()).highChance, factor * factor + ((Config)this.getConfig()).lowChance);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void on(BlockDropItemEvent e) {
        ItemStack luckDrop;
        Material m;
        double d;
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        Block broken = e.getBlock();
        if (broken.getType() == Material.GRASS || broken.getType() == Material.TALL_GRASS) {
            d = Math.random() * 100.0;
            m = XList.getRandom(ItemListings.getHerbalLuckSeeds());
            if (d < this.getEffectiveness(this.getLevel(p))) {
                this.xp(p, 100.0);
                luckDrop = new ItemStack(m, 1);
                e.getBlock().getWorld().dropItem(e.getBlock().getLocation(), luckDrop);
            }
        }
        if (ItemListings.getFlowers().contains(broken.getType())) {
            d = Math.random() * 100.0;
            m = XList.getRandom(ItemListings.getHerbalLuckFood());
            if (d < this.getEffectiveness(this.getLevel(p))) {
                this.xp(p, 100.0);
                luckDrop = new ItemStack(m, 1);
                e.getBlock().getWorld().dropItem(e.getBlock().getLocation(), luckDrop);
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 8;
        int maxLevel = 7;
        int initialCost = 3;
        double costFactor = 0.75;
        double lowChance = 0.0;
        double highChance = 90.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

