/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.herbalism;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.skill.SkillHerbalism;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Cuboid;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.M;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class HerbalismReplant
extends SimpleAdaptation<Config> {
    public HerbalismReplant() {
        super("herbalism-replant");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("herbalism", "replant", "description"));
        this.setDisplayName(Localizer.dLocalize("herbalism", "replant", "name"));
        this.setIcon(Material.PUMPKIN_SEEDS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(6090L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + this.getRadius(level) + C.GRAY + Localizer.dLocalize("herbalism", "replant", "lore1"));
    }

    private int getCooldown(double factor, int level) {
        if (level == 1) {
            return (int)((Config)this.getConfig()).cooldownLvl1;
        }
        return (int)(((Config)this.getConfig()).baseCooldown - ((Config)this.getConfig()).cooldownFactor * factor + ((Config)this.getConfig()).bonusCooldown);
    }

    private float getRadius(int lvl) {
        return lvl - ((Config)this.getConfig()).radiusSub;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (e.getClickedBlock() == null) {
            return;
        }
        if (!e.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (!(e.getClickedBlock().getBlockData() instanceof Ageable)) {
            return;
        }
        int lvl = this.getLevel(p);
        if (lvl > 0) {
            ItemStack right = p.getInventory().getItemInMainHand();
            ItemStack left = p.getInventory().getItemInOffHand();
            if (this.isTool(left) && this.isHoe(left) && !p.hasCooldown(left.getType())) {
                this.damageOffHand(p, 1 + (lvl - 1) * 7);
                p.setCooldown(left.getType(), this.getCooldown(this.getLevelPercent(p), this.getLevel(p)));
            } else if (this.isTool(right) && this.isHoe(right) && !p.hasCooldown(right.getType())) {
                this.damageHand(p, 1 + (lvl - 1) * 7);
                p.setCooldown(right.getType(), this.getCooldown(this.getLevelPercent(p), this.getLevel(p)));
            } else {
                return;
            }
            if (lvl > 1) {
                Cuboid c = new Cuboid(e.getClickedBlock().getLocation().clone().add(0.5, 0.5, 0.5));
                c = c.expand(Cuboid.CuboidDirection.Up, (int)Math.floor(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.Down, (int)Math.floor(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.North, Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.South, Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.East, Math.round(this.getRadius(lvl)));
                c = c.expand(Cuboid.CuboidDirection.West, Math.round(this.getRadius(lvl)));
                for (Block i : c) {
                    J.s(() -> this.hit(p, i), M.irand(1, 6));
                }
                p.getWorld().playSound(p.getLocation(), Sound.ITEM_SHOVEL_FLATTEN, 1.0f, 0.66f);
                p.getWorld().playSound(p.getLocation(), Sound.BLOCK_BAMBOO_SAPLING_BREAK, 1.0f, 0.66f);
                if (((Config)this.getConfig()).showParticles) {
                    p.spawnParticle(Particle.VILLAGER_HAPPY, p.getLocation().clone().add(0.5, 0.5, 0.5), this.getLevel(p) * 3, 0.3 * (double)this.getLevel(p), 0.3 * (double)this.getLevel(p), 0.3 * (double)this.getLevel(p), 0.9);
                }
            } else {
                this.hit(p, e.getClickedBlock());
            }
        }
    }

    private void hit(Player p, Block b) {
        BlockData blockData;
        if (b != null && (blockData = b.getBlockData()) instanceof Ageable) {
            Ageable aa = (Ageable)blockData;
            if (this.hasAdaptation(p)) {
                if (aa.getAge() == 0) {
                    return;
                }
                this.xp(p, b.getLocation().clone().add(0.5, 0.5, 0.5), ((SkillHerbalism.Config)this.getSkill().getConfig()).harvestPerAgeXP * (double)aa.getAge());
                this.xp(p, b.getLocation().clone().add(0.5, 0.5, 0.5), ((SkillHerbalism.Config)this.getSkill().getConfig()).plantCropSeedsXP);
                if (this.getPlayer(p).getData().getSkillLines().get("herbalism").getAdaptations().get("herbalism-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("herbalism").getAdaptations().get("herbalism-drop-to-inventory").getLevel() > 0) {
                    Collection items = b.getDrops();
                    for (ItemStack i : items) {
                        p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
                        i.setAmount(1);
                        if (p.getInventory().addItem(new ItemStack[]{i}).isEmpty()) continue;
                        p.getWorld().dropItem(p.getLocation(), i);
                    }
                    aa.setAge(0);
                    J.s(() -> b.setBlockData((BlockData)aa, true));
                } else {
                    p.breakBlock(b);
                }
                aa.setAge(0);
                J.s(() -> b.setBlockData((BlockData)aa, true));
                this.getPlayer(p).getData().addStat("harvest.blocks", 1.0);
                this.getPlayer(p).getData().addStat("harvest.planted", 1.0);
                if (M.r(1.0 / (double)this.getLevel(p))) {
                    p.getWorld().playSound(b.getLocation(), Sound.ITEM_CROP_PLANT, 1.0f, 0.7f);
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 3;
        int initialCost = 4;
        double costFactor = 2.325;
        double cooldownLvl1 = 2.0;
        double baseCooldown = 30.0;
        double cooldownFactor = 30.0;
        double bonusCooldown = 20.0;
        int radiusSub = 1;

        static {
            IBootstrap.dasBoot();
        }
    }
}

