/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.hunter;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class HunterDropToInventory
extends SimpleAdaptation<Config> {
    public HunterDropToInventory() {
        super("hunter-drop-to-inventory");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("hunter", "droptoinventory", "description"));
        this.setDisplayName(Localizer.dLocalize("hunter", "droptoinventory", "name"));
        this.setIcon(Material.DIRT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(18440L);
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("hunter", "droptoinventory", "lore1"));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(BlockDropItemEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (p.getGameMode() != GameMode.SURVIVAL) {
            return;
        }
        if (ItemListings.toolSwords.contains(p.getInventory().getItemInMainHand().getType())) {
            List<Item> items = XList.copy(e.getItems());
            e.getItems().clear();
            p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
            for (Item i : items) {
                this.xp(p, 2.0);
                if (p.getInventory().addItem(new ItemStack[]{i.getItemStack()}).isEmpty()) continue;
                p.getWorld().dropItem(p.getLocation(), i.getItemStack());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDeathEvent e) {
        LivingEntity k = e.getEntity();
        if (k.getKiller() == null || k.getKiller().getType() != EntityType.PLAYER) {
            return;
        }
        Player p = k.getKiller();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (e.getEntity() instanceof Player) {
            return;
        }
        if (e.getEntity().getKiller() != null && e.getEntity().getKiller().getClass().getSimpleName().equals("CraftPlayer")) {
            p.playSound(p.getLocation(), Sound.BLOCK_CALCITE_HIT, 0.05f, 0.01f);
            e.getDrops().forEach(i -> {
                this.xp(p, 2.0);
                if (!p.getInventory().addItem(new ItemStack[]{i}).isEmpty()) {
                    p.getWorld().dropItem(p.getLocation(), i);
                }
            });
            e.getDrops().clear();
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 1;
        int maxLevel = 1;
        int initialCost = 2;
        double costFactor = 1.0;

        static {
            IBootstrap.dasBoot();
        }
    }
}

