/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeAutosmelt
extends SimpleAdaptation<Config> {
    public PickaxeAutosmelt() {
        super("pickaxe-autosmelt");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "autosmelt", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "autosmelt", "name"));
        this.setIcon(Material.RAW_GOLD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(7444L);
    }

    static void autosmeltBlockDTI(Block b, Player p) {
        int fortune = 1;
        Random random = new Random();
        if (p.getInventory().getItemInMainHand().getEnchantments().get(Enchantment.LOOT_BONUS_BLOCKS) != null) {
            fortune = p.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + random.nextInt(3);
        }
        switch (b.getType()) {
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                if (!p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.IRON_INGOT, fortune)}).isEmpty()) {
                    b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.IRON_INGOT, fortune));
                }
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case NETHER_GOLD_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                if (!p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GOLD_INGOT, fortune)}).isEmpty()) {
                    b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.GOLD_INGOT, fortune));
                }
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                if (!p.getInventory().addItem(new ItemStack[]{new ItemStack(Material.COPPER_INGOT, fortune)}).isEmpty()) {
                    b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.COPPER_INGOT, fortune));
                }
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
            }
        }
    }

    static void autosmeltBlock(Block b, Player p) {
        int fortune = 1;
        Random random = new Random();
        if (p.getInventory().getItemInMainHand().getEnchantments().get(Enchantment.LOOT_BONUS_BLOCKS) != null) {
            fortune = p.getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS) + random.nextInt(3);
        }
        switch (b.getType()) {
            case IRON_ORE: 
            case DEEPSLATE_IRON_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.IRON_INGOT, fortune));
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case GOLD_ORE: 
            case DEEPSLATE_GOLD_ORE: 
            case NETHER_GOLD_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.GOLD_INGOT, fortune));
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
                break;
            }
            case COPPER_ORE: 
            case DEEPSLATE_COPPER_ORE: {
                if (b.getLocation().getWorld() == null) {
                    return;
                }
                b.setType(Material.AIR);
                b.getLocation().getWorld().dropItemNaturally(b.getLocation(), new ItemStack(Material.COPPER_INGOT, fortune));
                b.getWorld().playSound(b.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                b.getWorld().spawnParticle(Particle.LAVA, b.getLocation(), 3, 0.5, 0.5, 0.5);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("pickaxe", "autosmelt", "lore1"));
        v.addLore(C.GREEN + (double)level * 1.25 + C.GRAY + Localizer.dLocalize("pickaxe", "autosmelt", "lore2"));
    }

    @EventHandler
    public void on(BlockBreakEvent e) {
        Player p = e.getPlayer();
        if (e.isCancelled()) {
            return;
        }
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (!e.getBlock().getBlockData().getMaterial().name().endsWith("_ORE") && !ItemListings.getSmeltOre().contains(e.getBlock().getType())) {
            return;
        }
        this.xp(p, 5.0);
        if (this.getPlayer(p).getData().getSkillLines() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
            PickaxeAutosmelt.autosmeltBlockDTI(e.getBlock(), p);
        } else {
            PickaxeAutosmelt.autosmeltBlock(e.getBlock(), p);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 4;
        int initialCost = 4;
        double costFactor = 2.325;

        static {
            IBootstrap.dasBoot();
        }
    }
}

