/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.pickaxe;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.pickaxe.PickaxeAutosmelt;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class PickaxeVeinminer
extends SimpleAdaptation<Config> {
    public PickaxeVeinminer() {
        super("pickaxe-veinminer");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("pickaxe", "veinminer", "description"));
        this.setDisplayName(Localizer.dLocalize("pickaxe", "veinminer", "name"));
        this.setIcon(Material.IRON_PICKAXE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.setInterval(8484L);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + Localizer.dLocalize("pickaxe", "veinminer", "lore1"));
        v.addLore(C.GREEN + (level + ((Config)this.getConfig()).baseRange) + C.GRAY + " " + Localizer.dLocalize("pickaxe", "veinminer", "lore2"));
        v.addLore(C.ITALIC + Localizer.dLocalize("pickaxe", "veinminer", "lore3"));
    }

    private int getRadius(int lvl) {
        return lvl + ((Config)this.getConfig()).baseRange;
    }

    @EventHandler
    public void on(BlockBreakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (!p.isSneaking()) {
            return;
        }
        if (!e.getBlock().getBlockData().getMaterial().name().endsWith("_ORE") && !e.getBlock().getType().equals((Object)Material.OBSIDIAN)) {
            return;
        }
        Block block = e.getBlock();
        HashMap<Location, Block> blockMap = new HashMap<Location, Block>();
        blockMap.put(block.getLocation(), block);
        for (int i = 0; i < this.getRadius(this.getLevel(p)); ++i) {
            for (int x = -i; x <= i; ++x) {
                for (int y = -i; y <= i; ++y) {
                    for (int z = -i; z <= i; ++z) {
                        Block b = block.getRelative(x, y, z);
                        if (b.getType() != block.getType()) continue;
                        blockMap.put(b.getLocation(), b);
                    }
                }
            }
        }
        J.s(() -> {
            for (Location l : blockMap.keySet()) {
                if (!this.canBlockBreak(p, l)) {
                    Adapt.verbose("Player " + p.getName() + " doesn't have permission.");
                    continue;
                }
                Block b = e.getBlock().getWorld().getBlockAt(l);
                if (this.getPlayer(p).getData().getSkillLines() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-autosmelt") != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-autosmelt").getLevel() > 0) {
                    if (this.getPlayer(p).getData().getSkillLines() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
                        PickaxeAutosmelt.autosmeltBlockDTI(b, p);
                        continue;
                    }
                    PickaxeAutosmelt.autosmeltBlock(b, p);
                    continue;
                }
                if (this.getPlayer(p).getData().getSkillLines() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations() != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory") != null && this.getPlayer(p).getData().getSkillLines().get("pickaxe").getAdaptations().get("pickaxe-drop-to-inventory").getLevel() > 0) {
                    b.getDrops(p.getInventory().getItemInMainHand(), (Entity)p).forEach(item -> {
                        HashMap extra = p.getInventory().addItem(new ItemStack[]{item});
                        extra.forEach((k, v) -> p.getWorld().dropItem(p.getLocation(), v));
                    });
                    b.setType(Material.AIR);
                    continue;
                }
                b.breakNaturally(p.getItemInUse());
                e.getBlock().getWorld().playSound(e.getBlock().getLocation(), Sound.BLOCK_FUNGUS_BREAK, 0.4f, 0.25f);
                if (!((Config)this.getConfig()).showParticles) continue;
                e.getBlock().getWorld().spawnParticle(Particle.ASH, e.getBlock().getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 0.1);
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 4;
        double costFactor = 2.325;
        int baseRange = 2;

        static {
            IBootstrap.dasBoot();
        }
    }
}

