/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.ranged;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

public class RangedPiercing
extends SimpleAdaptation<Config> {
    private final List<Integer> holds = new ArrayList<Integer>();

    public RangedPiercing() {
        super("ranged-piercing");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("ranged", "arrowpiercing", "description"));
        this.setDisplayName(Localizer.dLocalize("ranged", "arrowpiercing", "name"));
        this.setIcon(Material.SHEARS);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(4791L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + level + C.GRAY + " " + Localizer.dLocalize("ranged", "arrowpiercing", "lore1"));
    }

    @EventHandler
    public void on(ProjectileLaunchEvent e) {
        if (e.isCancelled()) {
            return;
        }
        ProjectileSource projectileSource = e.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player p = (Player)projectileSource;
            Projectile projectile = e.getEntity();
            if (projectile instanceof AbstractArrow) {
                AbstractArrow a = (AbstractArrow)projectile;
                this.xp(p, 5.0);
                if (this.hasAdaptation(p)) {
                    a.setPierceLevel(((AbstractArrow)e.getEntity()).getPierceLevel() + this.getLevel(p));
                }
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 3;
        int maxLevel = 5;
        int initialCost = 8;
        double costFactor = 0.5;

        static {
            IBootstrap.dasBoot();
        }
    }
}

