/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.nms.NMS;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class RiftEnderchest
extends SimpleAdaptation<Config> {
    public RiftEnderchest() {
        super("rift-enderchest");
        this.setDescription(Localizer.dLocalize("rift", "chest", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "chest", "name"));
        this.setIcon(Material.ENDER_CHEST);
        this.setBaseCost(0);
        this.setCostFactor(0.0);
        this.setMaxLevel(1);
        this.setInitialCost(10);
        this.setInterval(9248L);
        this.registerConfiguration(Config.class);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "chest", "lore1"));
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (hand.getType() != Material.ENDER_CHEST || !this.hasAdaptation(p)) {
            return;
        }
        if (p.hasCooldown(hand.getType())) {
            e.setCancelled(true);
        } else {
            NMS.get().sendCooldown(p, Material.ENDER_CHEST, 100);
            p.setCooldown(Material.ENDER_CHEST, 100);
            if (e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (this.getPlayer(p).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist") != null && this.getPlayer(p).getData().getSkillLines().get("rift").getAdaptations().get("rift-resist").getLevel() > 0) {
                    RiftResist.riftResistStackAdd(p, 10, 2);
                }
                p.playSound(p.getLocation(), Sound.PARTICLE_SOUL_ESCAPE, 1.0f, 0.1f);
                p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 0.1f);
                p.openInventory(p.getEnderChest());
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;

        static {
            IBootstrap.dasBoot();
        }
    }
}

