/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.rift;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.api.recipe.AdaptRecipe;
import com.volmit.adapt.content.adaptation.rift.RiftResist;
import com.volmit.adapt.content.item.BoundEyeOfEnder;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RiftGate
extends SimpleAdaptation<Config> {
    public RiftGate() {
        super("rift-gate");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("rift", "gate", "description"));
        this.setDisplayName(Localizer.dLocalize("rift", "gate", "name"));
        this.setIcon(Material.END_PORTAL_FRAME);
        this.setBaseCost(0);
        this.setCostFactor(0.0);
        this.setMaxLevel(1);
        this.setInitialCost(30);
        this.setInterval(1322L);
        this.registerRecipe(AdaptRecipe.shapeless().key("rift-recall-gate").ingredient(Material.ENDER_PEARL).ingredient(Material.AMETHYST_SHARD).ingredient(Material.EMERALD).result(BoundEyeOfEnder.io.withData(new BoundEyeOfEnder.Data(null))).build());
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.YELLOW + Localizer.dLocalize("rift", "gate", "lore1"));
        v.addLore(C.RED + Localizer.dLocalize("rift", "gate", "lore2"));
        v.addLore(C.ITALIC + Localizer.dLocalize("rift", "gate", "lore3") + C.UNDERLINE + C.RED + Localizer.dLocalize("rift", "gate", "lore4"));
    }

    @EventHandler
    public void on(PlayerInteractEvent e) {
        Location location;
        Player p = e.getPlayer();
        ItemStack hand = p.getInventory().getItemInMainHand();
        ItemStack offHand = p.getInventory().getItemInOffHand();
        Location location2 = location = e.getClickedBlock() == null ? p.getLocation() : e.getClickedBlock().getLocation();
        if (BoundEyeOfEnder.isBindableItem(offHand) && e.getHand() != null && e.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            e.setCancelled(true);
            return;
        }
        if (p.getInventory().getItemInMainHand().getType().equals((Object)Material.ENDER_EYE) && !p.hasCooldown(Material.ENDER_EYE) && this.hasAdaptation(p) && BoundEyeOfEnder.isBindableItem(hand)) {
            e.setCancelled(true);
            Adapt.verbose(" - Player Main hand: " + hand.getType());
            switch (e.getAction()) {
                case LEFT_CLICK_BLOCK: 
                case LEFT_CLICK_AIR: {
                    if (!p.isSneaking()) break;
                    Adapt.verbose("Linking eye");
                    this.linkEye(p, location);
                    break;
                }
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    if (!this.isBound(hand)) break;
                    this.openEye(p);
                }
            }
        }
    }

    private void handleEyeOfEnderInteraction(PlayerInteractEvent event, Player player, Block block) {
        boolean sneaking = player.isSneaking();
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        Location location = block == null ? player.getLocation() : block.getLocation();
        switch (event.getAction()) {
            case LEFT_CLICK_BLOCK: 
            case LEFT_CLICK_AIR: {
                if (!sneaking) break;
                if (this.isBound(mainHand)) {
                    this.unlinkEye(player);
                    break;
                }
                this.linkEye(player, location);
                break;
            }
            case RIGHT_CLICK_AIR: 
            case RIGHT_CLICK_BLOCK: {
                if (!this.isBound(mainHand)) break;
                this.openEye(player);
                break;
            }
        }
    }

    private boolean isBound(ItemStack stack) {
        return stack.getType().equals((Object)Material.ENDER_EYE) && BoundEyeOfEnder.getLocation(stack) != null;
    }

    private void unlinkEye(Player p) {
        ItemStack hand = p.getInventory().getItemInMainHand();
        this.decrementItemstack(hand, p);
        ItemStack eye = new ItemStack(Material.ENDER_EYE);
        p.getInventory().addItem(new ItemStack[]{eye}).values().forEach(i -> p.getWorld().dropItemNaturally(p.getLocation(), i));
    }

    private void linkEye(Player p, Location location) {
        if (((Config)this.getConfig()).showParticles) {
            this.vfxCuboidOutline(location.getBlock(), location.add(0.0, 1.0, 0.0).getBlock(), Particle.REVERSE_PORTAL);
        }
        p.playSound(p.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 0.5f, 0.22f);
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (hand.getAmount() == 1) {
            BoundEyeOfEnder.setData(hand, location);
        } else {
            hand.setAmount(hand.getAmount() - 1);
            ItemStack eye = BoundEyeOfEnder.withData(location);
            p.getInventory().addItem(new ItemStack[]{eye}).values().forEach(i -> p.getWorld().dropItemNaturally(p.getLocation(), i));
        }
    }

    private void openEye(Player p) {
        Adapt.verbose("Using eye");
        Location l = BoundEyeOfEnder.getLocation(p.getInventory().getItemInMainHand());
        ItemStack hand = p.getInventory().getItemInMainHand();
        if (((Config)this.getConfig()).consumeOnUse) {
            this.xp(p, 75.0);
            this.decrementItemstack(hand, p);
        } else if (p.getCooldown(Material.ENDER_EYE) > 0) {
            p.playSound(p.getLocation(), Sound.BLOCK_REDSTONE_TORCH_BURNOUT, 1.0f, 1.0f);
            return;
        }
        p.setCooldown(Material.ENDER_EYE, 150);
        if (RiftResist.hasRiftResistPerk(this.getPlayer(p))) {
            RiftResist.riftResistStackAdd(p, 150, 3);
        }
        p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 10, true, false, false));
        p.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 85, 0, true, false, false));
        p.playSound(l, Sound.BLOCK_LODESTONE_PLACE, 1.0f, 0.1f);
        p.playSound(l, Sound.BLOCK_BELL_RESONATE, 1.0f, 0.1f);
        J.a(() -> {
            double radius = 2.0;
            double adder = 0.0;
            Color color = Color.fromBGR((int)0, (int)0, (int)0);
            this.vfxFastRing(p.getLocation(), radius, color);
            for (long dur = 4000L; dur > 0L; dur -= 50L) {
                this.vfxFastRing(p.getLocation().add(0.0, adder += 0.02, 0.0), radius *= 0.9, color);
                J.sleep(50L);
            }
        });
        this.vfxLevelUp(p);
        p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 5.35f, 0.1f);
        J.s(() -> {
            p.teleport(l, PlayerTeleportEvent.TeleportCause.PLUGIN);
            this.vfxLevelUp(p);
            p.playSound(p.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 5.35f, 0.1f);
        }, 85);
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        boolean consumeOnUse = true;
        boolean showParticles = true;

        static {
            IBootstrap.dasBoot();
        }
    }
}

