/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.seaborrne;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.extensions.java.util.List.XList;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class SeaborneFishersFantasy
extends SimpleAdaptation<Config> {
    public SeaborneFishersFantasy() {
        super("seaborne-fishers-fantasy");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("seaborn", "fishersfantasy", "description"));
        this.setDisplayName(Localizer.dLocalize("seaborn", "fishersfantasy", "name"));
        this.setIcon(Material.FISHING_ROD);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(8080L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GRAY + Localizer.dLocalize("seaborn", "fishersfantasy", "lore1"));
    }

    @EventHandler
    public void on(PlayerFishEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (e.getState() == PlayerFishEvent.State.CAUGHT_FISH) {
            Random random = new Random();
            for (int i = 0; i < this.getLevel(p); ++i) {
                ItemStack item = new ItemStack(XList.getRandom(ItemListings.getFishingDrops()), 1);
                if (!random.nextBoolean()) continue;
                p.getWorld().dropItemNaturally(p.getLocation(), item);
                p.getWorld().spawn(p.getLocation(), ExperienceOrb.class);
                Adapt.verbose("Fishing Gift Donated!");
                this.xp(p, 15 * this.getLevel(p));
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 5;
        int maxLevel = 7;
        int initialCost = 2;
        double costFactor = 1.525;

        static {
            IBootstrap.dasBoot();
        }
    }
}

