/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Inventories;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StealthSnatch
extends SimpleAdaptation<Config> {
    private final List<Integer> holds;

    public StealthSnatch() {
        super("stealth-snatch");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "snatch", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "snatch", "name"));
        this.setIcon(Material.CHEST_MINECART);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(((Config)this.getConfig()).snatchRate);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.holds = new ArrayList<Integer>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.f(this.getRange(this.getLevelPercent(level)), 1) + C.GRAY + " " + Localizer.dLocalize("stealth", "snatch", "lore1"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (e.isSneaking()) {
            this.snatch(p);
        }
    }

    private void snatch(Player player) {
        double factor = this.getLevelPercent(player);
        if (factor == 0.0) {
            return;
        }
        double range = this.getRange(factor);
        HashSet<Item> items = new HashSet<Item>();
        for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), range, range / 1.5, range)) {
            Item droppedItem;
            if (!(entity instanceof Item) || (droppedItem = (Item)entity).getPickupDelay() > 0 && droppedItem.getTicksLived() <= 1) continue;
            items.add(droppedItem);
        }
        for (Item item : items) {
            double dist;
            if (this.holds.contains(item.getEntityId()) || !((dist = item.getLocation().distanceSquared(player.getLocation())) < range * range)) continue;
            ItemStack is = item.getItemStack().clone();
            if (!Inventories.hasSpace((Inventory)player.getInventory(), is)) continue;
            this.holds.add(item.getEntityId());
            player.getWorld().playSound(player.getLocation(), Sound.BLOCK_LAVA_POP, 1.0f, (float)(1.0 + Math.random() / 3.0));
            this.safeGiveItem(player, (Entity)item, is);
            this.sendCollected(player, item);
            int id = item.getEntityId();
            J.s(() -> this.holds.remove((Object)id));
        }
    }

    private double getRange(double factor) {
        return factor * ((Config)this.getConfig()).radiusFactor + 1.0;
    }

    public void sendCollected(Player p, Item item) {
        try {
            PacketPlayOutCollect packet = new PacketPlayOutCollect(item.getEntityId(), p.getEntityId(), item.getItemStack().getAmount());
            for (Entity i : p.getWorld().getNearbyEntities(p.getLocation(), 8.0, 8.0, 8.0, entity -> entity instanceof Player)) {
                ((CraftPlayer)i).getHandle().b.a((Packet)packet);
            }
        }
        catch (Exception e) {
            Adapt.error("Failed to send collected packet");
            e.printStackTrace();
        }
    }

    @Override
    public void onTick() {
        for (Player i : Bukkit.getOnlinePlayers()) {
            if (!i.isSneaking()) continue;
            J.s(() -> this.snatch(i));
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int snatchRate = 250;
        int baseCost = 4;
        int maxLevel = 3;
        int initialCost = 12;
        double costFactor = 0.125;
        double radiusFactor = 5.55;

        static {
            IBootstrap.dasBoot();
        }
    }
}

