/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.stealth;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class StealthSpeed
extends SimpleAdaptation<Config> {
    public StealthSpeed() {
        super("stealth-speed");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("stealth", "speed", "description"));
        this.setDisplayName(Localizer.dLocalize("stealth", "speed", "name"));
        this.setIcon(Material.MUSHROOM_STEW);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setInterval(2000L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getSpeed(this.getLevelPercent(level)), 0) + C.GRAY + Localizer.dLocalize("stealth", "speed", "lore1"));
    }

    @EventHandler
    public void on(PlayerToggleSneakEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        double factor = this.getLevelPercent(p);
        if (!this.hasAdaptation(p)) {
            return;
        }
        if (factor == 0.0) {
            return;
        }
        AttributeModifier mod = new AttributeModifier("adapt-sneak-speed", this.getSpeed(factor), AttributeModifier.Operation.MULTIPLY_SCALAR_1);
        if (e.isSneaking()) {
            p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).addModifier(mod);
        } else {
            for (AttributeModifier i : p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getModifiers()) {
                if (!i.getName().equals("adapt-sneak-speed")) continue;
                p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).removeModifier(i);
            }
        }
    }

    private double getSpeed(double factor) {
        return factor * ((Config)this.getConfig()).factor;
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 2;
        int initialCost = 5;
        double costFactor = 0.6;
        double factor = 1.25;

        static {
            IBootstrap.dasBoot();
        }
    }
}

