/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.sword;

import com.volmit.adapt.Adapt;
import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.content.adaptation.sword.effects.DamagingBleedEffect;
import com.volmit.adapt.content.item.ItemListings;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class SwordsBloodyBlade
extends SimpleAdaptation<Config> {
    private final Map<Player, Long> cooldowns;

    public SwordsBloodyBlade() {
        super("sword-bloody-blade");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("sword", "bloodyblade", "description"));
        this.setDisplayName(Localizer.dLocalize("sword", "bloodyblade", "name"));
        this.setIcon(Material.RED_DYE);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInterval(5534L);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
        this.cooldowns = new HashMap<Player, Long>();
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore1"));
        v.addLore(C.YELLOW + "* " + Form.duration(this.getDurationOfEffect(level), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore2"));
        v.addLore(C.RED + "* " + Form.duration(this.getCooldown(level), 1) + C.GRAY + " " + Localizer.dLocalize("sword", "bloodyblade", "lore3"));
    }

    public long getCooldown(int level) {
        return ((Config)this.getConfig()).cooldown * (long)level;
    }

    public long getDurationOfEffect(int level) {
        return ((Config)this.getConfig()).effectDuration * (long)level;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(EntityDamageByEntityEvent e) {
        Player p;
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getDamager();
        if (entity instanceof Player && this.hasAdaptation(p = (Player)entity) && ItemListings.getToolSwords().contains(p.getInventory().getItemInMainHand().getType())) {
            Player pvic;
            if (this.cooldowns.containsKey(p)) {
                if (this.cooldowns.get(p).compareTo(System.currentTimeMillis()) > 0) {
                    return;
                }
                this.cooldowns.remove(p);
            }
            Entity victim = e.getEntity();
            this.cooldowns.put(p, System.currentTimeMillis() + this.getCooldown(this.getLevel(p)));
            if (victim instanceof Player ? !this.canPVP(p, (pvic = (Player)victim).getLocation()) : !this.canPVE(p, victim.getLocation())) {
                return;
            }
            if (((Config)this.getConfig()).showParticles) {
                BleedEffect bleedEffect;
                if (victim instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)victim;
                    bleedEffect = new DamagingBleedEffect(Adapt.instance.adaptEffectManager, ((Config)this.getConfig()).damagePerBleedProc, l);
                } else {
                    bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                }
                blood = bleedEffect;
                blood.setEntity(victim);
                blood.material = Material.CRIMSON_ROOTS;
                blood.height = -1.0;
                blood.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(p)) / 1000L));
                blood.period = 5;
                blood.hurt = false;
                blood.start();
            } else {
                BleedEffect bleedEffect;
                if (victim instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)victim;
                    bleedEffect = new DamagingBleedEffect(Adapt.instance.adaptEffectManager, ((Config)this.getConfig()).damagePerBleedProc, l);
                } else {
                    bleedEffect = new BleedEffect(Adapt.instance.adaptEffectManager);
                }
                blood = bleedEffect;
                blood.setEntity(victim);
                blood.material = Material.VOID_AIR;
                blood.height = -1.0;
                blood.iterations = Math.toIntExact(2L * (3L + this.getDurationOfEffect(this.getLevel(p)) / 1000L));
                blood.period = 5;
                blood.hurt = false;
                blood.start();
            }
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        public long cooldown = 5000L;
        public double damagePerBleedProc = 0.5;
        public long effectDuration = 1000L;
        boolean permanent = false;
        boolean enabled = true;
        boolean showParticles = true;
        int baseCost = 7;
        int maxLevel = 7;
        int initialCost = 7;
        double costFactor = 0.325;

        static {
            IBootstrap.dasBoot();
        }
    }
}

