/*
 * Decompiled with CFR 0.152.
 */
package com.volmit.adapt.content.adaptation.taming;

import com.volmit.adapt.api.adaptation.SimpleAdaptation;
import com.volmit.adapt.util.C;
import com.volmit.adapt.util.Element;
import com.volmit.adapt.util.Form;
import com.volmit.adapt.util.J;
import com.volmit.adapt.util.Localizer;
import com.volmit.adapt.util.manifold.rt.api.IBootstrap;
import java.util.Collection;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;

public class TamingDamage
extends SimpleAdaptation<Config> {
    private final UUID attUUID = UUID.nameUUIDFromBytes("tame-damage-boost".getBytes());
    private final String attid = "att-tame-damage-boost";

    public TamingDamage() {
        super("tame-damage");
        this.registerConfiguration(Config.class);
        this.setDescription(Localizer.dLocalize("taming", "damage", "description"));
        this.setDisplayName(Localizer.dLocalize("taming", "damage", "name"));
        this.setIcon(Material.FLINT);
        this.setBaseCost(((Config)this.getConfig()).baseCost);
        this.setMaxLevel(((Config)this.getConfig()).maxLevel);
        this.setInitialCost(((Config)this.getConfig()).initialCost);
        this.setInterval(6119L);
        this.setCostFactor(((Config)this.getConfig()).costFactor);
    }

    @Override
    public void addStats(int level, Element v) {
        v.addLore(C.GREEN + "+ " + Form.pc(this.getDamageBoost(level), 0) + C.GRAY + " " + Localizer.dLocalize("taming", "damage", "lore1"));
    }

    private double getDamageBoost(int level) {
        return this.getLevelPercent(level) * ((Config)this.getConfig()).damageFactor + ((Config)this.getConfig()).baseDamage;
    }

    @Override
    public void onTick() {
        for (World i : Bukkit.getServer().getWorlds()) {
            J.s(() -> {
                Collection gl = i.getEntitiesByClass(Tameable.class);
                J.a(() -> {
                    for (Tameable j : gl) {
                        AnimalTamer patt2835$temp;
                        if (!j.isTamed() || !((patt2835$temp = j.getOwner()) instanceof Player)) continue;
                        Player p = (Player)patt2835$temp;
                        this.update(j, this.getLevel(p));
                    }
                });
            });
        }
    }

    private void update(Tameable j, int level) {
        AttributeModifier mod = new AttributeModifier(this.attUUID, "att-tame-damage-boost", this.getDamageBoost(level), AttributeModifier.Operation.ADD_SCALAR);
        if (j.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE) == null) {
            return;
        }
        j.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).removeModifier(mod);
        if (level > 0) {
            j.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).addModifier(mod);
        }
    }

    @Override
    public boolean isEnabled() {
        return ((Config)this.getConfig()).enabled;
    }

    @Override
    public boolean isPermanent() {
        return ((Config)this.getConfig()).permanent;
    }

    static {
        IBootstrap.dasBoot();
    }

    protected static class Config {
        boolean permanent = false;
        boolean enabled = true;
        int baseCost = 6;
        int maxLevel = 5;
        int initialCost = 5;
        double costFactor = 0.4;
        double baseDamage = 0.08;
        double damageFactor = 0.65;

        static {
            IBootstrap.dasBoot();
        }
    }
}

